/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.parts;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.parts.AbstractTwoPointCreationTool;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLElementTypes;
import org.eclipse.uml2.uml.UMLPackage;

public class GeneralOrderingCreationTool
extends AbstractTwoPointCreationTool {
    public GeneralOrderingCreationTool() {
        super(UMLElementTypes.GeneralOrdering_Shape);
    }

    @Override
    protected boolean validateFirstTarget(EditPart firstTarget) {
        return firstTarget != null && EditPartUtils.isEditPartFor(firstTarget, UMLPackage.eINSTANCE.getOccurrenceSpecification());
    }

    @Override
    protected boolean validateSecondTarget(EditPart firstTarget, EditPart secondTarget) {
        if (secondTarget == null || !EditPartUtils.isEditPartFor(secondTarget, UMLPackage.eINSTANCE.getOccurrenceSpecification())) {
            return false;
        }
        return GeneralOrderingCreationTool.ordered(firstTarget, secondTarget);
    }

    @Override
    protected Command getCommand(EditPart firstTarget, EditPart secondTarget, Request request) {
        return secondTarget.getParent().getCommand(request);
    }

    @Override
    protected void started() {
        GeneralOrderingCreationTool.setStatusMessage(Messages.GeneralOrderingCreationTool_ClickBefore);
    }

    @Override
    protected void firstElementSelected() {
        GeneralOrderingCreationTool.setStatusMessage(Messages.GeneralOrderingCreationTool_ClickAfter);
    }
}

