/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.ptp.internal.rm.lml.core.events.NodedisplayZoomEvent;
import org.eclipse.ptp.internal.rm.lml.core.events.RectangleSizeChangeEvent;
import org.eclipse.ptp.rm.lml.core.elements.Nodedisplay;
import org.eclipse.ptp.rm.lml.core.events.INodedisplayZoomEvent;
import org.eclipse.ptp.rm.lml.core.events.IRectangleSizeChangeEvent;
import org.eclipse.ptp.rm.lml.core.listeners.INodedisplayZoomListener;
import org.eclipse.ptp.rm.lml.core.listeners.IRectangleSizeChangeListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.ui.providers.LguiWidget;
import org.eclipse.ptp.rm.lml.ui.providers.NodedisplayComp;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractNodedisplayView
extends LguiWidget {
    private final List<INodedisplayZoomListener> zoomListeners = new LinkedList<INodedisplayZoomListener>();
    private final List<IRectangleSizeChangeListener> rectangleListeners = new LinkedList<IRectangleSizeChangeListener>();
    private int fixedLevel = -1;

    public AbstractNodedisplayView(ILguiItem lguiItem, Composite parent, int style) {
        super(lguiItem, parent, style);
    }

    public void addRectangleListener(IRectangleSizeChangeListener listener) {
        this.rectangleListeners.add(listener);
    }

    public void addZoomListener(INodedisplayZoomListener listener) {
        this.zoomListeners.add(listener);
    }

    public void decreaseRectangles() {
        if (this.getMinimalRectangleSize() <= 0) {
            return;
        }
        this.setMinimalRectangleSize(this.getMinimalRectangleSize() - 1);
    }

    public int getFixedLevel() {
        return this.fixedLevel;
    }

    public abstract int getMaximumNodedisplayDepth();

    public abstract int getMinimalRectangleSize();

    public abstract int getMinimumLevelOfDetail();

    public abstract NodedisplayComp getRootNodedisplay();

    public abstract int getShownMaxLevel();

    public abstract boolean goToImpName(String var1);

    public void increaseRectangles() {
        this.setMinimalRectangleSize(this.getMinimalRectangleSize() + 1);
    }

    public void removeRectangleListener(IRectangleSizeChangeListener listener) {
        this.rectangleListeners.remove(listener);
    }

    public void removeZoomListener(INodedisplayZoomListener listener) {
        this.zoomListeners.remove(listener);
    }

    public abstract void restartZoom();

    public void setFixedLevel(int level) {
        this.fixedLevel = level;
    }

    public abstract void setMaxLevel(int var1);

    public void setMinimalRectangleSize(int size) {
        this.notifyRectangleSizeChange(size);
    }

    public void update() {
        super.update();
    }

    public abstract void update(ILguiItem var1);

    public abstract void update(ILguiItem var1, Nodedisplay var2);

    public abstract void zoomIn(String var1);

    public abstract void zoomOut();

    protected void notifyRectangleSizeChange(int newSize) {
        RectangleSizeChangeEvent event = new RectangleSizeChangeEvent(newSize);
        for (IRectangleSizeChangeListener listener : this.rectangleListeners) {
            listener.handleEvent((IRectangleSizeChangeEvent)event);
        }
    }

    protected void notifyZoom(INodedisplayZoomEvent event) {
        for (INodedisplayZoomListener listener : this.zoomListeners) {
            listener.handleEvent(event);
        }
    }

    protected void notifyZoom(String impName, boolean zoomIn) {
        NodedisplayZoomEvent event = new NodedisplayZoomEvent(impName, zoomIn);
        this.notifyZoom((INodedisplayZoomEvent)event);
    }
}

