/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.requirement;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.internal.configuration.RequirementConfigurationSet;
import org.eclipse.reddeer.junit.internal.requirement.RequirementHelper;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.requirement.ConfigurableRequirement;
import org.eclipse.reddeer.junit.requirement.Requirement;
import org.eclipse.reddeer.junit.requirement.configuration.MissingRequirementConfiguration;
import org.eclipse.reddeer.junit.requirement.configuration.RequirementConfiguration;

public class RequirementsBuilder {
    private static final Logger log = Logger.getLogger(RequirementsBuilder.class);

    public Requirements build(RequirementConfigurationSet configurationSet, Class<?> clazz) {
        if (configurationSet == null || clazz == null) {
            throw new IllegalArgumentException("Configuration set nor clazz cannot be null.");
        }
        ArrayList requirements = new ArrayList();
        if (!configurationSet.getConfigurationSet().contains(new MissingRequirementConfiguration())) {
            List<Requirement<?>> rawRequirements = RequirementHelper.getRequirements(clazz);
            for (Requirement<?> requirement : rawRequirements) {
                if (ConfigurableRequirement.class.isAssignableFrom(requirement.getClass())) {
                    ConfigurableRequirement customRequirement = (ConfigurableRequirement)requirement;
                    for (RequirementConfiguration configuration : configurationSet.getConfigurationSet()) {
                        if (!customRequirement.getConfigurationClass().isAssignableFrom(configuration.getClass())) continue;
                        customRequirement.setConfiguration(configuration);
                        break;
                    }
                }
                requirements.add(requirement);
            }
        }
        return new Requirements(requirements, clazz, configurationSet.getId());
    }
}

