/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.condition;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.api.TreeItem;

public class TreeHasSelectedItems
extends AbstractWaitCondition {
    private Logger log = Logger.getLogger(TreeHasSelectedItems.class);
    private Tree tree;
    private int numSelectedItems;
    private List<TreeItem> resultItems;

    public TreeHasSelectedItems(Tree tree) {
        this(tree, 1);
    }

    public TreeHasSelectedItems(Tree tree, int numSelectedItems) {
        this.numSelectedItems = numSelectedItems;
        this.tree = tree;
        this.resultItems = new ArrayList<TreeItem>();
    }

    public boolean test() {
        this.resultItems = this.tree.getSelectedItems();
        this.log.trace("Count of selected tree items:" + this.resultItems.size());
        if (this.resultItems.size() == this.numSelectedItems) {
            this.log.trace(this.tree.getSelectedItems().get(0).getText());
            return true;
        }
        return false;
    }

    public String description() {
        return "tree has " + this.numSelectedItems + " selected items";
    }

    public List<TreeItem> getResult() {
        return this.resultItems.isEmpty() ? null : this.resultItems;
    }
}

