/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.internal.permission.descriptors;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionProvider;
import org.eclipse.sirius.ecore.extender.business.internal.ExtenderPlugin;
import org.eclipse.sirius.ecore.extender.business.internal.Messages;
import org.eclipse.sirius.ecore.extender.business.internal.permission.PermissionProviderDescriptor;
import org.eclipse.sirius.ecore.extender.business.internal.permission.descriptors.AbstractPermissionProviderDescriptor;

public class EclipsePermissionProviderDescriptor
extends AbstractPermissionProviderDescriptor
implements PermissionProviderDescriptor {
    private static final String PROVIDER_CLASS_ATTR = "providerClass";
    private IConfigurationElement configurationElement;

    public EclipsePermissionProviderDescriptor(String id, int priority, IConfigurationElement configurationElement) {
        this.id = id;
        this.priority = priority;
        this.configurationElement = configurationElement;
    }

    @Override
    public IPermissionProvider getPermissionProvider() {
        if (this.permissionProvider == null) {
            try {
                this.permissionProvider = (IPermissionProvider)this.configurationElement.createExecutableExtension(PROVIDER_CLASS_ATTR);
            }
            catch (CoreException e) {
                String providerClassName = this.configurationElement.getAttribute(PROVIDER_CLASS_ATTR);
                IContributor contributor = this.configurationElement.getDeclaringExtension().getContributor();
                Status status = new Status(4, "org.eclipse.sirius.ecore.extender", MessageFormat.format(Messages.PermissionService_permissionProviderInstantiationError, providerClassName, contributor.getName()), (Throwable)e);
                ExtenderPlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
        return this.permissionProvider;
    }
}

