/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.testers;

import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.FsClipboard;

public class ClipboardPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Assert.isTrue((boolean)(receiver instanceof IStructuredSelection));
        if (property.equals("canPaste")) {
            FsClipboard cb = UIPlugin.getClipboard();
            if (!cb.isEmpty()) {
                String tid;
                IFSTreeNode head;
                String hid;
                List<IFSTreeNode> nodes = cb.getFiles();
                boolean moving = cb.isCutOp();
                boolean copying = cb.isCopyOp();
                List selection = ((IStructuredSelection)receiver).toList();
                IFSTreeNode hovered = null;
                Assert.isTrue((!selection.isEmpty() ? 1 : 0) != 0);
                if (selection.size() == 1) {
                    IFSTreeNode node = (IFSTreeNode)selection.get(0);
                    hovered = node.isDirectory() && moving ? node : (node.isRootDirectory() ? node : node.getParent());
                } else {
                    for (IFSTreeNode node : selection) {
                        if (hovered == null) {
                            hovered = node.getParent();
                            continue;
                        }
                        if (hovered == node.getParent()) continue;
                        return false;
                    }
                }
                if (hovered != null && hovered.isDirectory() && hovered.isWritable() && (moving || copying) && (hid = (head = nodes.get(0)).getPeerNode().getPeerId()).equals(tid = hovered.getPeerNode().getPeerId())) {
                    for (IFSTreeNode node : nodes) {
                        if ((!moving || node.getParent() != hovered) && !node.isAncestorOf(hovered)) continue;
                        return false;
                    }
                    return true;
                }
            } else {
                Clipboard clipboard = cb.getSystemClipboard();
                Object contents = clipboard.getContents((Transfer)FileTransfer.getInstance());
                if (contents != null) {
                    List selection = ((IStructuredSelection)receiver).toList();
                    IFSTreeNode hovered = null;
                    Assert.isTrue((!selection.isEmpty() ? 1 : 0) != 0);
                    if (selection.size() == 1) {
                        IFSTreeNode node = (IFSTreeNode)selection.get(0);
                        hovered = node.isFile() ? node.getParent() : node;
                    } else {
                        for (IFSTreeNode node : selection) {
                            if (hovered == null) {
                                hovered = node.getParent();
                                continue;
                            }
                            if (hovered == node.getParent()) continue;
                            return false;
                        }
                    }
                    return hovered != null && hovered.isDirectory() && hovered.isWritable();
                }
            }
        }
        return false;
    }
}

