/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.IResourceStateChangeListener;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.core.util.ResourceStateChangeListeners;
import org.eclipse.team.internal.ccvs.ui.CVSDecoration;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.core.ExceptionCollector;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ITeamStateDescription;
import org.eclipse.team.ui.mapping.SynchronizationStateTester;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class CVSLightweightDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
IResourceStateChangeListener,
IPropertyChangeListener {
    public static final String ID = "org.eclipse.team.cvs.ui.decorator";
    private static ExceptionCollector exceptions = new ExceptionCollector(CVSUIMessages.CVSDecorator_exceptionMessage, "org.eclipse.team.cvs.ui", 4, CVSUIPlugin.getPlugin().getLog());
    private static String DECORATOR_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static SimpleDateFormat decorateFormatter = new SimpleDateFormat(DECORATOR_FORMAT, Locale.getDefault());
    private static String[] fonts = new String[]{"org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_font", "org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_font"};
    private static String[] colors = new String[]{"org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_background_color", "org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_foreground_color", "org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_background_color", "org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_foreground_color"};
    private static final SynchronizationStateTester DEFAULT_TESTER = new SynchronizationStateTester();

    public CVSLightweightDecorator() {
        ResourceStateChangeListeners.getListener().addResourceStateChangeListener((IResourceStateChangeListener)this);
        TeamUI.addPropertyChangeListener((IPropertyChangeListener)this);
        CVSUIPlugin.addPropertyChangeListener(this);
        this.ensureFontAndColorsCreated(fonts, colors);
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener((IPropertyChangeListener)this);
        CVSProviderPlugin.broadcastDecoratorEnablementChanged((boolean)true);
    }

    private void ensureFontAndColorsCreated(String[] fonts, String[] colors) {
        CVSUIPlugin.getStandardDisplay().syncExec(() -> {
            ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            String[] stringArray3 = colors;
            int n = colors.length;
            int n2 = 0;
            while (n2 < n) {
                String color = stringArray3[n2];
                theme.getColorRegistry().get(color);
                ++n2;
            }
            stringArray3 = fonts;
            n = fonts.length;
            n2 = 0;
            while (n2 < n) {
                String font = stringArray3[n2];
                theme.getFontRegistry().get(font);
                ++n2;
            }
        });
    }

    public static boolean isDirty(ICVSResource resource) throws CVSException {
        return CVSLightweightDecorator.getSubscriber().isDirty(resource, null);
    }

    public static boolean isDirty(IResource resource) {
        try {
            return CVSLightweightDecorator.getSubscriber().isDirty(resource, null);
        }
        catch (CVSException e) {
            CVSLightweightDecorator.handleException(resource, (CoreException)((Object)e));
            return true;
        }
    }

    private static CVSTeamProvider getCVSProviderFor(IResource resource) {
        if (resource == null) {
            return null;
        }
        RepositoryProvider p = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId());
        if (p == null) {
            return null;
        }
        return (CVSTeamProvider)p;
    }

    public void decorate(Object element, IDecoration decoration) {
        block8: {
            IResource resource = CVSLightweightDecorator.getResource(element);
            if (resource != null && resource.getType() == 8) {
                return;
            }
            ResourceMapping mapping = Utils.getResourceMapping((Object)element);
            if (mapping == null) {
                return;
            }
            if (!this.isMappedToCVS(mapping)) {
                return;
            }
            IDecorationContext context = decoration.getDecorationContext();
            SynchronizationStateTester tester = DEFAULT_TESTER;
            Object property = context.getProperty("org.eclipse.team.ui.syncStateTester");
            if (property instanceof SynchronizationStateTester) {
                tester = (SynchronizationStateTester)property;
            }
            try {
                if (tester.isDecorationEnabled(element)) {
                    CVSDecoration cvsDecoration = CVSLightweightDecorator.decorate(element, tester);
                    cvsDecoration.apply(decoration);
                }
            }
            catch (CoreException e) {
                this.handleException(element, e);
            }
            catch (IllegalStateException e) {
                if (Platform.getBundle((String)"org.eclipse.team.cvs.ui").getState() != 32) break block8;
                throw e;
            }
        }
    }

    private static IResource getResource(Object element) {
        if (element instanceof ResourceMapping) {
            element = ((ResourceMapping)element).getModelObject();
        }
        return Utils.getResource((Object)element);
    }

    private boolean isMappedToCVS(ResourceMapping mapping) {
        IProject[] projects = mapping.getProjects();
        boolean foundOne = false;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project != null) {
                RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                if (provider instanceof CVSTeamProvider) {
                    foundOne = true;
                } else if (provider != null) {
                    return false;
                }
            }
            ++n2;
        }
        return foundOne;
    }

    public static CVSDecoration decorate(Object element, SynchronizationStateTester tester) throws CoreException {
        IResource resource;
        CVSTag tag;
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        CVSDecoration result = new CVSDecoration();
        int state = 0;
        if (CVSLightweightDecorator.isSupervised(element)) {
            result.setHasRemote(true);
            state = tester.getState(element, store.getBoolean("pref_calculate_dirty") ? 263 : 0, (IProgressMonitor)new NullProgressMonitor());
            result.setStateFlags(state);
        } else {
            result.setIgnored(true);
        }
        if (!result.isIgnored() && (tag = CVSLightweightDecorator.getTagToShow(element)) != null) {
            Date date;
            String name = tag.getName();
            if (tag.getType() == 3 && (date = tag.asDate()) != null) {
                name = decorateFormatter.format(date);
            }
            result.setTag(name);
        }
        if ((resource = CVSLightweightDecorator.getResource(element)) == null) {
            result.setResourceType(1000);
        } else {
            CVSLightweightDecorator.decorate(resource, result);
        }
        tester.elementDecorated(element, (ITeamStateDescription)result.asTeamStateDescription(null));
        return result;
    }

    private static boolean isSupervised(Object element) throws CoreException {
        IResource[] resources;
        IResource[] iResourceArray = resources = CVSLightweightDecorator.getTraversalRoots(element);
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (CVSLightweightDecorator.getSubscriber().isSupervised(resource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IResource[] getTraversalRoots(Object element) throws CoreException {
        HashSet result = new HashSet();
        ResourceMapping mapping = Utils.getResourceMapping((Object)element);
        if (mapping != null) {
            ResourceTraversal[] traversals;
            ResourceTraversal[] resourceTraversalArray = traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
            int n = traversals.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceTraversal traversal = resourceTraversalArray[n2];
                IResource[] resources = traversal.getResources();
                Collections.addAll(result, resources);
                ++n2;
            }
        }
        return result.toArray(new IResource[result.size()]);
    }

    private static void decorate(IResource resource, CVSDecoration cvsDecoration) throws CVSException {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        cvsDecoration.setResourceType(resource.getType());
        cvsDecoration.setHasRemote(CVSLightweightDecorator.hasRemote(cvsResource));
        if (cvsResource.isIgnored()) {
            cvsDecoration.setIgnored(true);
        }
        if (!cvsDecoration.isIgnored()) {
            boolean decorateModel = store.getBoolean("pref_calculate_dirty");
            if (!decorateModel) {
                try {
                    IDiff node = CVSLightweightDecorator.getSubscriber().getDiff(resource);
                    if (node != null && node instanceof IThreeWayDiff) {
                        IThreeWayDiff twd = (IThreeWayDiff)node;
                        cvsDecoration.setDirty(twd.getDirection() == 256 || twd.getDirection() == 768);
                    }
                }
                catch (CoreException e) {
                    CVSLightweightDecorator.handleException(resource, e);
                }
            }
            if (store.getBoolean("pref_show_newresource") && cvsResource.exists()) {
                if (cvsResource.isFolder()) {
                    if (!((ICVSFolder)cvsResource).isCVSFolder()) {
                        cvsDecoration.setNewResource(true);
                    }
                } else if (!cvsResource.isManaged()) {
                    cvsDecoration.setNewResource(true);
                }
            }
            if (resource.getType() == 1) {
                CVSLightweightDecorator.extractFileProperties((IFile)resource, cvsDecoration);
            } else {
                CVSLightweightDecorator.extractContainerProperties((IContainer)resource, cvsDecoration);
            }
        }
    }

    private static boolean hasRemote(ICVSResource cvsResource) {
        try {
            return cvsResource.isManaged() || cvsResource.isFolder() && ((ICVSFolder)cvsResource).isCVSFolder();
        }
        catch (CVSException cVSException) {
            return false;
        }
    }

    public static CVSDecoration decorate(IResource resource, boolean includeDirtyCheck) throws CVSException {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        CVSDecoration cvsDecoration = new CVSDecoration();
        cvsDecoration.setResourceType(resource.getType());
        if (cvsResource.isIgnored()) {
            cvsDecoration.setIgnored(true);
        }
        if (!cvsDecoration.isIgnored() && includeDirtyCheck) {
            boolean computeDeepDirtyCheck = store.getBoolean("pref_calculate_dirty");
            int type = resource.getType();
            if (type == 1 || computeDeepDirtyCheck) {
                cvsDecoration.setDirty(CVSLightweightDecorator.isDirty(resource));
            }
        }
        CVSLightweightDecorator.decorate(resource, cvsDecoration);
        return cvsDecoration;
    }

    private static void extractContainerProperties(IContainer resource, CVSDecoration cvsDecoration) throws CVSException {
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)resource);
        FolderSyncInfo folderInfo = folder.getFolderSyncInfo();
        if (folderInfo != null) {
            cvsDecoration.setLocation(KnownRepositories.getInstance().getRepository(folderInfo.getRoot()));
            if (!resource.getFullPath().toString().substring(1).equals(folderInfo.getRepository())) {
                cvsDecoration.setRepository(folderInfo.getRepository());
            }
            cvsDecoration.setVirtualFolder(folderInfo.isVirtualDirectory());
        }
    }

    private static void extractFileProperties(IFile resource, CVSDecoration cvsDecoration) throws CVSException {
        ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)resource);
        ResourceSyncInfo fileInfo = file.getSyncInfo();
        Command.KSubstOption option = Command.KSubstOption.fromFile((IFile)resource);
        if (fileInfo != null) {
            cvsDecoration.setAdded(fileInfo.isAdded());
            cvsDecoration.setRevision(fileInfo.getRevision());
            cvsDecoration.setReadOnly(file.isReadOnly());
            cvsDecoration.setNeedsMerge(fileInfo.isNeedsMerge(file.getTimeStamp()));
            option = fileInfo.getKeywordMode();
        }
        cvsDecoration.setKeywordSubstitution(option.getShortDisplayText());
        CVSTeamProvider provider = CVSLightweightDecorator.getCVSProviderFor((IResource)resource);
        if (provider != null) {
            cvsDecoration.setWatchEditEnabled(provider.isWatchEditEnabled());
        }
    }

    protected static CVSTag getTagToShow(Object element) throws CoreException {
        IResource r = CVSLightweightDecorator.getResource(element);
        if (r != null) {
            return CVSLightweightDecorator.getTagToShow(r);
        }
        IResource[] resources = CVSLightweightDecorator.getTraversalRoots(element);
        boolean first = true;
        CVSTag tag = null;
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (CVSLightweightDecorator.getSubscriber().isSupervised(resource)) {
                CVSTag nextTag = CVSLightweightDecorator.getTagToShow(resource);
                if (first) {
                    tag = nextTag;
                    first = false;
                } else if (!CVSLightweightDecorator.equals(tag, nextTag)) {
                    return null;
                }
            }
            ++n2;
        }
        return tag;
    }

    private static boolean equals(CVSTag tag, CVSTag nextTag) {
        if (tag == nextTag) {
            return true;
        }
        if (tag == null || nextTag == null) {
            return false;
        }
        return tag.getName().equals(nextTag.getName());
    }

    protected static CVSTag getTagToShow(IResource resource) throws CVSException {
        FolderSyncInfo parentInfo;
        ICVSFolder parent;
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        CVSEntryLineTag tag = null;
        boolean managed = false;
        if (cvsResource.isFolder()) {
            FolderSyncInfo folderInfo = ((ICVSFolder)cvsResource).getFolderSyncInfo();
            if (folderInfo != null) {
                tag = folderInfo.getTag();
                managed = true;
            }
        } else {
            ResourceSyncInfo info = ((ICVSFile)cvsResource).getSyncInfo();
            if (info != null) {
                tag = info.getTag();
                managed = true;
            }
        }
        if ((parent = cvsResource.getParent()) != null && managed && (parentInfo = parent.getFolderSyncInfo()) != null) {
            CVSEntryLineTag parentTag = parentInfo.getTag();
            parentTag = parentTag == null ? CVSTag.DEFAULT : parentTag;
            Object object = tag = tag == null ? CVSTag.DEFAULT : tag;
            if (parentTag.getName().equals(tag.getName())) {
                tag = null;
            }
        }
        return tag;
    }

    private void addWithParents(IResource resource, Set resources) {
        IResource current = resource;
        while (current.getType() != 8) {
            resources.add(current);
            current = current.getParent();
        }
    }

    public static void refresh() {
        PlatformUI.getWorkbench().getDecoratorManager().update(ID);
    }

    public void refresh(IProject project) {
        ArrayList resources = new ArrayList();
        try {
            project.accept(resource -> {
                resources.add(resource);
                return true;
            });
            this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, resources.toArray()));
        }
        catch (CoreException e) {
            CVSLightweightDecorator.handleException((IResource)project, e);
        }
    }

    public void resourceSyncInfoChanged(IResource[] changedResources) {
        this.resourceStateChanged(changedResources);
    }

    public void externalSyncInfoChange(IResource[] changedResources) {
        this.resourceStateChanged(changedResources);
    }

    public void resourceModified(IResource[] changedResources) {
        this.resourceStateChanged(changedResources);
    }

    public void resourceStateChanged(IResource[] changedResources) {
        HashSet<IResource> resourcesToUpdate = new HashSet<IResource>();
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        boolean showingDeepDirtyIndicators = store.getBoolean("pref_calculate_dirty");
        IResource[] iResourceArray = changedResources;
        int n = changedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (showingDeepDirtyIndicators) {
                this.addWithParents(resource, resourcesToUpdate);
            } else {
                resourcesToUpdate.add(resource);
            }
            ++n2;
        }
        this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, resourcesToUpdate.toArray()));
    }

    public void projectConfigured(IProject project) {
        this.refresh(project);
    }

    public void projectDeconfigured(IProject project) {
        this.refresh(project);
    }

    private void postLabelEvent(LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(() -> this.fireLabelProviderChanged(event));
    }

    public void dispose() {
        super.dispose();
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().removePropertyChangeListener((IPropertyChangeListener)this);
        CVSProviderPlugin.broadcastDecoratorEnablementChanged((boolean)false);
        TeamUI.removePropertyChangeListener((IPropertyChangeListener)this);
        CVSUIPlugin.removePropertyChangeListener(this);
    }

    private static void handleException(IResource resource, CoreException e) {
        if (resource == null || resource.isAccessible()) {
            exceptions.handleException(e);
        }
    }

    private void handleException(Object element, CoreException e) {
        IProject[] projects;
        IResource resource = Utils.getResource((Object)element);
        if (resource != null) {
            CVSLightweightDecorator.handleException(resource, e);
        }
        ResourceMapping mapping = Utils.getResourceMapping((Object)element);
        IProject[] iProjectArray = projects = mapping.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!project.isAccessible()) {
                return;
            }
            ++n2;
        }
        exceptions.handleException(e);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.isEventOfInterest(event)) {
            this.ensureFontAndColorsCreated(fonts, colors);
            CVSLightweightDecorator.refresh();
        }
    }

    private boolean isEventOfInterest(PropertyChangeEvent event) {
        String prop = event.getProperty();
        return prop.equals("org.eclipse.team.uiglobal_ignores_changed") || prop.equals("org.eclipse.team.uiglobal_file_types_changed") || prop.equals("org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED") || prop.equals("org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_background_color") || prop.equals("org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_foreground_color") || prop.equals("org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_font") || prop.equals("org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_foreground_color") || prop.equals("org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_background_color") || prop.equals("org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_font");
    }

    private static CVSWorkspaceSubscriber getSubscriber() {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
    }
}

