/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.CheckOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;

public class InequalityCheck
implements ISearchOperation {
    int sourceLocation;
    int targetLocation;

    public InequalityCheck(int sourceLocation, int targetLocation) {
        this.sourceLocation = sourceLocation;
        this.targetLocation = targetLocation;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "check     " + variableMapping.apply(this.sourceLocation) + " != " + variableMapping.apply(this.targetLocation);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.sourceLocation, this.targetLocation);
    }

    private class Executor
    extends CheckOperationExecutor {
        private Executor() {
        }

        @Override
        protected boolean check(MatchingFrame frame, ISearchContext context) {
            Object source = frame.getValue(InequalityCheck.this.sourceLocation);
            Object target = frame.getValue(InequalityCheck.this.targetLocation);
            if (source == null) {
                throw new LocalSearchException("Source not bound.");
            }
            if (target == null) {
                throw new LocalSearchException("Target not bound");
            }
            return !source.equals(target);
        }

        @Override
        public ISearchOperation getOperation() {
            return InequalityCheck.this;
        }
    }
}

