/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.converters;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.xwt.IValueConverter;
import org.eclipse.xwt.XWT;

public class ValueConverterAdapter
implements IValueConverter {
    private IConverter fromConvertor;
    private IConverter toConvertor;

    public ValueConverterAdapter(IConverter fromConvertor, IConverter toConvertor) {
        this.fromConvertor = fromConvertor;
        this.toConvertor = toConvertor;
    }

    @Override
    public Object convertBack(Object value) {
        return this.toConvertor.convert(value);
    }

    public Object convert(Object fromObject) {
        return this.fromConvertor.convert(fromObject);
    }

    public Object getFromType() {
        return this.fromConvertor.getFromType();
    }

    public Object getToType() {
        return this.toConvertor.getFromType();
    }

    public static ValueConverterAdapter create(Class<?> sourceType, Class<?> targetType) {
        IConverter fromConvertor = XWT.findConvertor(sourceType, targetType);
        if (fromConvertor == null) {
            return null;
        }
        IConverter toConvertor = XWT.findConvertor(targetType, sourceType);
        if (toConvertor == null) {
            return null;
        }
        return new ValueConverterAdapter(fromConvertor, toConvertor);
    }
}

