/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.DockerCredentialHelperAuth;
import org.mandas.docker.client.messages.RegistryAuth;

final class ImmutableDockerCredentialHelperAuth
implements DockerCredentialHelperAuth {
    private final String username;
    private final String secret;
    @Nullable
    private final String serverUrl;
    private final transient RegistryAuth toRegistryAuth;

    private ImmutableDockerCredentialHelperAuth(String username, String secret, @Nullable String serverUrl) {
        this.username = username;
        this.secret = secret;
        this.serverUrl = serverUrl;
        this.toRegistryAuth = Objects.requireNonNull(DockerCredentialHelperAuth.super.toRegistryAuth(), "toRegistryAuth");
    }

    @Override
    @JsonProperty(value="Username")
    public String username() {
        return this.username;
    }

    @Override
    @JsonProperty(value="Secret")
    public String secret() {
        return this.secret;
    }

    @Override
    @JsonProperty(value="ServerURL")
    @Nullable
    public String serverUrl() {
        return this.serverUrl;
    }

    @Override
    @JsonProperty(value="toRegistryAuth")
    @JsonIgnore
    public RegistryAuth toRegistryAuth() {
        return this.toRegistryAuth;
    }

    public final ImmutableDockerCredentialHelperAuth withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableDockerCredentialHelperAuth(newValue, this.secret, this.serverUrl);
    }

    public final ImmutableDockerCredentialHelperAuth withSecret(String value) {
        String newValue = Objects.requireNonNull(value, "secret");
        if (this.secret.equals(newValue)) {
            return this;
        }
        return new ImmutableDockerCredentialHelperAuth(this.username, newValue, this.serverUrl);
    }

    public final ImmutableDockerCredentialHelperAuth withServerUrl(@Nullable String value) {
        if (Objects.equals(this.serverUrl, value)) {
            return this;
        }
        return new ImmutableDockerCredentialHelperAuth(this.username, this.secret, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDockerCredentialHelperAuth && this.equalTo((ImmutableDockerCredentialHelperAuth)another);
    }

    private boolean equalTo(ImmutableDockerCredentialHelperAuth another) {
        return this.username.equals(another.username) && this.secret.equals(another.secret) && Objects.equals(this.serverUrl, another.serverUrl) && this.toRegistryAuth.equals(another.toRegistryAuth);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.secret.hashCode();
        h += (h << 5) + Objects.hashCode(this.serverUrl);
        h += (h << 5) + this.toRegistryAuth.hashCode();
        return h;
    }

    public String toString() {
        return "DockerCredentialHelperAuth{username=" + this.username + ", secret=" + this.secret + ", serverUrl=" + this.serverUrl + ", toRegistryAuth=" + this.toRegistryAuth + "}";
    }

    public static ImmutableDockerCredentialHelperAuth copyOf(DockerCredentialHelperAuth instance) {
        if (instance instanceof ImmutableDockerCredentialHelperAuth) {
            return (ImmutableDockerCredentialHelperAuth)instance;
        }
        return ImmutableDockerCredentialHelperAuth.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements DockerCredentialHelperAuth.Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private static final long INIT_BIT_SECRET = 2L;
        private long initBits = 3L;
        private String username;
        private String secret;
        private String serverUrl;

        private Builder() {
        }

        public final Builder from(DockerCredentialHelperAuth instance) {
            Objects.requireNonNull(instance, "instance");
            this.username(instance.username());
            this.secret(instance.secret());
            String serverUrlValue = instance.serverUrl();
            if (serverUrlValue != null) {
                this.serverUrl(serverUrlValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Username")
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="Secret")
        public final Builder secret(String secret) {
            this.secret = Objects.requireNonNull(secret, "secret");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty(value="ServerURL")
        public final Builder serverUrl(@Nullable String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        @Override
        public ImmutableDockerCredentialHelperAuth build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDockerCredentialHelperAuth(this.username, this.secret, this.serverUrl);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("secret");
            }
            return "Cannot build DockerCredentialHelperAuth, some of required attributes are not set " + attributes;
        }
    }
}

