/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.helpers;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class JavaScriptSource {
    static final JavaScriptSource singleton = new JavaScriptSource();
    private static Map<String, Boolean> R = new HashMap<String, Boolean>();

    static {
        JavaScriptSource.addReserved("abstract,as,boolean,break,byte,case,catch,char,class,continue");
        JavaScriptSource.addReserved("const,debugger,default,delete,do,double,else,enum,export,extends");
        JavaScriptSource.addReserved("false,final,finally,float,for,function,goto,if,implements");
        JavaScriptSource.addReserved("import,in,instanceof,int,interface,is,long,namespace,native");
        JavaScriptSource.addReserved("new,null,package,private,protected,public,return,short");
        JavaScriptSource.addReserved("static,super,switch,synchronized,this,throw,throws,transient");
        JavaScriptSource.addReserved("true,try,typeof,use,var,void,volatile,while,with");
    }

    private static void addReserved(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, ",;");
        while (tokenizer.hasMoreElements()) {
            String next = (String)tokenizer.nextElement();
            String nextTrim = next.trim();
            if (nextTrim.length() < 1) continue;
            R.put(nextTrim, Boolean.TRUE);
        }
    }

    public static boolean isReserved(String word) {
        return R.containsKey(word);
    }

    public static boolean isValidJSIdentifier(String word) {
        int i = 0;
        int j = word.length();
        while (i < j) {
            char ch = word.charAt(i);
            if (i == 0 ? !Character.isJavaIdentifierStart(ch) : !Character.isJavaIdentifierPart(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static JavaScriptSource getInstance() {
        return singleton;
    }

    public String toSource(String value) {
        if (value == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder(value.length());
        result.append('\"');
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '\"') {
                result.append("\\\"");
            } else if (c == '\\') {
                result.append("\\\\");
            } else if (c == '\n') {
                result.append("\\n");
            } else if (c == '\t') {
                result.append("\\t");
            } else if (c == '\\') {
                result.append("\\\\");
            } else if (c != '\r') {
                result.append(c);
            }
            ++i;
        }
        result.append('\"');
        return result.toString();
    }

    public String toSource(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Map) {
            return this.toSource((Map)o);
        }
        if (o instanceof Object[]) {
            return this.toSource((Object[])o);
        }
        if (o instanceof List) {
            return this.toSource((List)o);
        }
        if (o instanceof Number) {
            return this.toSource((Number)o);
        }
        if (o instanceof Boolean) {
            return this.toSource((Boolean)o);
        }
        if (o instanceof Date) {
            return this.toSource((Date)o);
        }
        if (o instanceof String) {
            return this.toSource((String)o);
        }
        if (o instanceof StringBuilder) {
            return this.toSource(((StringBuilder)o).toString());
        }
        if (o instanceof Expression) {
            return ((Expression)o).toString();
        }
        return "null";
    }

    public String toSource(Map<?, ?> aMap) {
        if (aMap == null) {
            return "null";
        }
        StringBuilder js = new StringBuilder("{");
        for (Map.Entry<?, ?> entry : aMap.entrySet()) {
            String key = entry.getKey().toString();
            if (JavaScriptSource.isReserved(key) || !JavaScriptSource.isValidJSIdentifier(key)) {
                js.append(this.toSource(key));
            } else {
                js.append(key);
            }
            js.append(":");
            js.append(this.toSource(entry.getValue()));
            js.append(",");
        }
        if (js.length() > 1) {
            js.setLength(js.length() - 1);
        }
        js.append("}");
        return js.toString();
    }

    public String toSource(List<?> o) {
        if (o == null) {
            return "null";
        }
        return this.toSource(o.toArray());
    }

    public String toSource(Object[] o) {
        if (o == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder("[");
        int i = 0;
        while (i < o.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.toSource(o[i]));
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public String toSource(Date d) {
        if (d == null) {
            return "null";
        }
        return "new Date(" + d.getTime() + ")";
    }

    public String toSource(Number n) {
        if (n == null) {
            return "0";
        }
        return n.toString();
    }

    public String toSource(Boolean b) {
        if (b == null) {
            return "false";
        }
        return b.toString();
    }

    public static class Expression {
        String mExpr;

        public Expression(String str) {
            this.mExpr = str;
        }

        public String toString() {
            return this.mExpr;
        }
    }
}

