/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.adapters;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ConversationNode;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.LoopCharacteristics;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.impl.ActivityImpl;
import org.eclipse.bpmn2.impl.CallableElementImpl;
import org.eclipse.bpmn2.impl.CatchEventImpl;
import org.eclipse.bpmn2.impl.ChoreographyActivityImpl;
import org.eclipse.bpmn2.impl.ConversationNodeImpl;
import org.eclipse.bpmn2.impl.EventDefinitionImpl;
import org.eclipse.bpmn2.impl.EventImpl;
import org.eclipse.bpmn2.impl.FlowElementImpl;
import org.eclipse.bpmn2.impl.FlowElementsContainerImpl;
import org.eclipse.bpmn2.impl.FlowNodeImpl;
import org.eclipse.bpmn2.impl.GatewayImpl;
import org.eclipse.bpmn2.impl.InteractionNodeImpl;
import org.eclipse.bpmn2.impl.LoopCharacteristicsImpl;
import org.eclipse.bpmn2.impl.ThrowEventImpl;
import org.eclipse.bpmn2.modeler.core.ToolTipProvider;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterRegistry;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterUtil;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.adapters.IResourceProvider;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.runtime.ITargetRuntimeProvider;
import org.eclipse.bpmn2.modeler.core.runtime.PropertyExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntimeAdapter;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.util.Bpmn2Resource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ExtendedPropertiesAdapter<T extends EObject>
extends AdapterImpl
implements IResourceProvider,
ITargetRuntimeProvider {
    public static final String LONG_DESCRIPTION = "long.description";
    public static final String UI_CAN_EDIT = "ui.can.edit";
    public static final String UI_CAN_EDIT_INLINE = "ui.can.edit.inline";
    public static final String UI_CAN_CREATE_NEW = "ui.can.create.new";
    public static final String UI_CAN_SET_NULL = "ui.can.set.null";
    public static final String UI_IS_MULTI_CHOICE = "ui.is.multi.choice";
    public static final String UI_OBJECT_EDITOR_CLASS = "ui.object.editor.class";
    public static final String OBJECT_DESCRIPTOR = "object.descriptor";
    public static final String FEATURE_DESCRIPTOR = "feature.descriptor";
    public static final String LINE_NUMBER = "line.number";
    public static final String IS_EXTENSION_FEATURE = "is.extension.feature";
    public static final String UI_SHOW_ITEMS_IN_SCOPE = "show.items.in.scope";
    protected Hashtable<String, Object> properties = new Hashtable();
    private Hashtable<EStructuralFeature, Hashtable<String, Object>> featureProperties = new Hashtable();
    private AdapterFactory adapterFactory;

    public ExtendedPropertiesAdapter(AdapterFactory adapterFactory, T object) {
        this.adapterFactory = adapterFactory;
        this.setTarget((Notifier)object);
    }

    public static ExtendedPropertiesAdapter adapt(Object object) {
        if (object instanceof EClass) {
            object = ExtendedPropertiesAdapter.getDummyObject((EClass)object);
        }
        if (object instanceof EObject) {
            return ExtendedPropertiesAdapter.adapt((EObject)object);
        }
        return null;
    }

    public static ExtendedPropertiesAdapter adapt(Resource resource, EClass eClass) {
        TargetRuntime rt = ExtendedPropertiesAdapter.getTargetRuntime((Notifier)resource);
        PropertyExtensionDescriptor ped = rt.getPropertyExtension(eClass.getInstanceClass());
        if (ped == null && rt != TargetRuntime.getDefaultRuntime()) {
            ped = TargetRuntime.getDefaultRuntime().getPropertyExtension(eClass.getInstanceClass());
        }
        if (ped != null) {
            return ped.getAdapter((AdapterFactory)new AdapterFactoryImpl(), (EObject)eClass);
        }
        EObject object = ExtendedPropertiesAdapter.getDummyObject(eClass);
        TargetRuntimeAdapter.adapt(object, rt);
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object);
        adapter.setResource(resource);
        adapter.setTargetRuntime(rt);
        return adapter;
    }

    public static ExtendedPropertiesAdapter adapt(Resource resource, EObject object, EStructuralFeature feature) {
        Assert.isTrue((feature != null ? 1 : 0) != 0);
        if (object instanceof EClass) {
            object = ExtendedPropertiesAdapter.getDummyObject((EClass)object);
        } else if (resource == null) {
            resource = ExtendedPropertiesAdapter.getResource((Notifier)object);
        }
        ExtendedPropertiesAdapter<EObject> adapter = null;
        TargetRuntime rt = null;
        if (resource != null && (rt = TargetRuntimeAdapter.getTargetRuntime((Notifier)resource)) != null) {
            TargetRuntimeAdapter.adapt(object, rt);
        }
        if ((adapter = AdapterUtil.adapt((Object)object, ExtendedPropertiesAdapter.class)) == null) {
            adapter = new ExtendedPropertiesAdapter<EObject>((AdapterFactory)new AdapterFactoryImpl(), object);
        }
        if (adapter != null) {
            adapter.setTarget((Notifier)object);
            adapter.getObjectDescriptor().setObject(object);
            adapter.getFeatureDescriptor(feature).setObject(object);
        }
        return adapter;
    }

    @Deprecated
    public static ExtendedPropertiesAdapter adapt(EClass object) {
        throw new IllegalArgumentException("ExtendedPropertiesAdapter: Can't adapt " + object.getName());
    }

    public static ExtendedPropertiesAdapter adapt(EObject object) {
        ExtendedPropertiesAdapter<EObject> adapter;
        if (object == null) {
            return null;
        }
        if (object instanceof EClass) {
            throw new IllegalArgumentException("ExtendedPropertiesAdapter: Can't adapt " + ((EClass)object).getName());
        }
        if (object instanceof ExtensionAttributeValue && object.eContainer() != null) {
            object = object.eContainer();
        }
        if ((adapter = AdapterUtil.adapt((Object)object, ExtendedPropertiesAdapter.class)) == null) {
            adapter = new ExtendedPropertiesAdapter<EObject>((AdapterFactory)new AdapterFactoryImpl(), object);
        }
        if (adapter != null) {
            adapter.setTarget((Notifier)object);
            adapter.getObjectDescriptor().setObject(object);
        }
        return adapter;
    }

    public static EObject getDummyObject(EClass eClass) {
        Object object = null;
        EFactory factory = eClass.getEPackage().getEFactoryInstance();
        if (factory instanceof Bpmn2ModelerFactory) {
            if (eClass.isAbstract()) {
                if (eClass.getInstanceClass() == Activity.class) {
                    object = new ActivityImpl(){};
                } else if (eClass.getInstanceClass() == CallableElement.class) {
                    object = new CallableElementImpl(){};
                } else if (eClass.getInstanceClass() == CatchEvent.class) {
                    object = new CatchEventImpl(){};
                } else if (eClass.getInstanceClass() == ChoreographyActivity.class) {
                    object = new ChoreographyActivityImpl(){};
                } else if (eClass.getInstanceClass() == ConversationNode.class) {
                    object = new ConversationNodeImpl(){};
                } else if (eClass.getInstanceClass() == Event.class) {
                    object = new EventImpl(){};
                } else if (eClass.getInstanceClass() == EventDefinition.class) {
                    object = new EventDefinitionImpl(){};
                } else if (eClass.getInstanceClass() == FlowElement.class) {
                    object = new FlowElementImpl(){};
                } else if (eClass.getInstanceClass() == FlowElementsContainer.class) {
                    object = new FlowElementsContainerImpl(){};
                } else if (eClass.getInstanceClass() == FlowNode.class) {
                    object = new FlowNodeImpl(){};
                } else if (eClass.getInstanceClass() == Gateway.class) {
                    object = new GatewayImpl(){};
                } else if (eClass.getInstanceClass() == InteractionNode.class) {
                    object = new InteractionNodeImpl(){};
                } else if (eClass.getInstanceClass() == LoopCharacteristics.class) {
                    object = new LoopCharacteristicsImpl(){};
                } else if (eClass.getInstanceClass() == ThrowEvent.class) {
                    object = new ThrowEventImpl(){};
                } else {
                    System.err.println("The abstract BPMN2 type " + eClass.getName() + " can not be constructed");
                }
            } else {
                object = ((Bpmn2ModelerFactory)factory).createInternal(eClass);
            }
        } else {
            object = factory.create(eClass);
        }
        return object;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setObjectDescriptor(ObjectDescriptor<T> od) {
        this.setProperty(OBJECT_DESCRIPTOR, od);
        od.setOwner(this);
    }

    public ObjectDescriptor<T> getObjectDescriptor() {
        ObjectDescriptor<EObject> od = (ObjectDescriptor<EObject>)this.getProperty(OBJECT_DESCRIPTOR);
        if (od == null) {
            od = new ObjectDescriptor<EObject>(this, (EObject)this.getTarget());
            this.setObjectDescriptor(od);
        }
        return od;
    }

    public boolean hasFeatureDescriptor(EStructuralFeature feature) {
        FeatureDescriptor fd = (FeatureDescriptor)this.getProperty(feature, FEATURE_DESCRIPTOR);
        return fd != null;
    }

    public FeatureDescriptor<T> getFeatureDescriptor(EStructuralFeature feature) {
        FeatureDescriptor<EObject> fd = (FeatureDescriptor<EObject>)this.getProperty(feature, FEATURE_DESCRIPTOR);
        if (fd == null) {
            fd = new FeatureDescriptor<EObject>(this, (EObject)this.getTarget(), feature);
            this.setFeatureDescriptor(feature, fd);
        }
        return fd;
    }

    public FeatureDescriptor<T> getFeatureDescriptor(String featureName) {
        EStructuralFeature feature = this.getFeature(featureName);
        return this.getFeatureDescriptor(feature);
    }

    public void setFeatureDescriptor(EStructuralFeature feature, FeatureDescriptor<T> fd) {
        Hashtable<String, Object> props = this.featureProperties.get(feature);
        if (props == null) {
            props = new Hashtable();
            this.featureProperties.put(feature, props);
        }
        fd.setOwner(this);
        props.put(FEATURE_DESCRIPTOR, fd);
    }

    public EStructuralFeature getFeature(String name) {
        ExtendedPropertiesAdapter adapter;
        EObject container;
        Object object = this.getObjectDescriptor().object;
        if (object instanceof ExtensionAttributeValue && (container = ((ExtensionAttributeValue)object).eContainer()) != null && (adapter = ExtendedPropertiesAdapter.adapt(container)) != null) {
            return adapter.getFeature(name);
        }
        for (Map.Entry<EStructuralFeature, Hashtable<String, Object>> entry : this.featureProperties.entrySet()) {
            EStructuralFeature feature = entry.getKey();
            if (!feature.getName().equals(name)) continue;
            return feature;
        }
        return null;
    }

    public List<EStructuralFeature> getFeatures() {
        ExtendedPropertiesAdapter adapter;
        EObject container;
        Object object = this.getObjectDescriptor().object;
        if (object instanceof ExtensionAttributeValue && (container = ((ExtensionAttributeValue)object).eContainer()) != null && (adapter = ExtendedPropertiesAdapter.adapt(container)) != null) {
            return adapter.getFeatures();
        }
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        features.addAll(this.featureProperties.keySet());
        return features;
    }

    public List<EStructuralFeature> getExtensionFeatures() {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        for (EStructuralFeature f : this.getFeatures()) {
            FeatureDescriptor<T> fd = this.getFeatureDescriptor(f);
            if (fd.getProperty(IS_EXTENSION_FEATURE) == null) continue;
            features.add(f);
        }
        return features;
    }

    private Hashtable<String, Object> getObjectProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties;
    }

    public Object getProperty(String key) {
        return this.getObjectProperties().get(key);
    }

    public <T> T getProperty(Class<T> clazz) {
        return (T)this.getProperty(clazz.getName());
    }

    public void setProperty(String key, Object value) {
        if (value == null) {
            this.getObjectProperties().remove(key);
        } else {
            this.getObjectProperties().put(key, value);
        }
    }

    public <T> void setProperty(Class<T> clazz, Object value) {
        this.setProperty(clazz.getName(), value);
    }

    public Object getProperty(EStructuralFeature feature, String key) {
        Hashtable<String, Object> props = this.featureProperties.get(feature);
        if (props == null) {
            props = new Hashtable();
            this.featureProperties.put(feature, props);
        }
        return props.get(key);
    }

    public boolean getBooleanProperty(String key) {
        Object result = this.getProperty(key);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    public boolean getBooleanProperty(EStructuralFeature feature, String key) {
        Object result = this.getProperty(feature, key);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    public void setProperty(EStructuralFeature feature, String key, Object value) {
        Hashtable<String, Object> props = this.featureProperties.get(feature);
        if (props == null) {
            props = new Hashtable();
            this.featureProperties.put(feature, props);
        }
        props.put(key, value);
    }

    public void setTarget(Notifier newTarget) {
        super.setTarget(newTarget);
        if (newTarget instanceof EObject && !(newTarget instanceof EClass)) {
            EObject object = (EObject)newTarget;
            for (Adapter a : object.eAdapters()) {
                if (!(a instanceof ExtendedPropertiesAdapter)) continue;
                return;
            }
            object.eAdapters().add((Object)this);
            this.setResource(ExtendedPropertiesAdapter.getResource((Notifier)object));
        }
    }

    public String getDescription(EObject object) {
        return ToolTipProvider.INSTANCE.getLongDescription(this.adapterFactory, object);
    }

    @Override
    public Resource getResource() {
        IResourceProvider rp;
        ObjectDescriptor od;
        Resource resource = this.getProperty(Resource.class);
        if (resource == null && (od = (ObjectDescriptor)this.getProperty(OBJECT_DESCRIPTOR)) != null && (rp = AdapterRegistry.INSTANCE.adapt((Object)od.object.eContainer(), IResourceProvider.class)) != null && rp != this) {
            resource = rp.getResource();
            this.setResource(resource);
        }
        return resource;
    }

    @Override
    public void setResource(Resource resource) {
        this.setProperty(Resource.class, (Object)resource);
    }

    @Override
    public TargetRuntime getTargetRuntime() {
        Resource resource;
        TargetRuntime rt = this.getProperty(TargetRuntime.class);
        if (rt == null && (rt = ExtendedPropertiesAdapter.getTargetRuntime((Notifier)(resource = this.getResource()))) != null) {
            this.setTargetRuntime(rt);
        }
        return rt;
    }

    @Override
    public void setTargetRuntime(TargetRuntime rt) {
        this.setProperty(TargetRuntime.class, (Object)rt);
    }

    public static Resource getResource(Notifier object) {
        IResourceProvider rp;
        ResourceSet rs;
        if (object == null) {
            return null;
        }
        Resource resource = null;
        EObject eObject = null;
        if (object instanceof EObject) {
            eObject = (EObject)object;
            resource = ((EObject)object).eResource();
        }
        if (object instanceof Resource) {
            resource = (Resource)object;
        }
        if (object instanceof ResourceSet && (rs = (ResourceSet)object).getResources().size() > 0) {
            resource = (Resource)rs.getResources().get(0);
        }
        if (resource == null && (rp = AdapterRegistry.INSTANCE.adapt((Object)object, IResourceProvider.class)) != null) {
            resource = rp.getResource();
        }
        if (resource == null && eObject != null) {
            for (Adapter a : eObject.eAdapters()) {
                if (a instanceof IResourceProvider && (resource = ((IResourceProvider)a).getResource()) != null) break;
            }
        }
        if (resource != null && !(resource instanceof Bpmn2Resource)) {
            rs = resource.getResourceSet();
            if (rs != null) {
                for (Resource r : rs.getResources()) {
                    if (!(r instanceof Bpmn2Resource)) continue;
                    return r;
                }
            }
            return null;
        }
        return resource;
    }

    public static TargetRuntime getTargetRuntime(Notifier object) {
        Resource resource;
        if (object == null) {
            return null;
        }
        TargetRuntime rt = null;
        if (object instanceof ResourceSet && (resource = ExtendedPropertiesAdapter.getResource(object)) != null) {
            object = resource;
        }
        for (Adapter a : object.eAdapters()) {
            if (!(a instanceof ITargetRuntimeProvider) || (rt = ((ITargetRuntimeProvider)a).getTargetRuntime()) == null) continue;
            return rt;
        }
        if (!(object instanceof Resource) && (resource = ExtendedPropertiesAdapter.getResource(object)) != null) {
            for (Adapter a : resource.eAdapters()) {
                if (!(a instanceof ITargetRuntimeProvider) || (rt = ((ITargetRuntimeProvider)a).getTargetRuntime()) == null) continue;
                return rt;
            }
        }
        return null;
    }

    public TransactionalEditingDomain getEditingDomain() {
        ComposeableAdapterFactory rootAdapterFactory;
        EditingDomain result = null;
        if (this.adapterFactory instanceof IEditingDomainProvider) {
            result = ((IEditingDomainProvider)this.adapterFactory).getEditingDomain();
        }
        if (result == null && this.adapterFactory instanceof ComposeableAdapterFactory && (rootAdapterFactory = ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory()) instanceof IEditingDomainProvider) {
            result = ((IEditingDomainProvider)rootAdapterFactory).getEditingDomain();
        }
        if (result instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)result;
        }
        return null;
    }

    public static boolean compare(EObject thisObject, EObject otherObject, boolean similar) {
        for (EStructuralFeature f : thisObject.eClass().getEAllStructuralFeatures()) {
            ExtendedPropertiesAdapter adapter;
            if (similar && "id".equals(f.getName())) continue;
            if (otherObject.eClass().getEStructuralFeature(f.getName()) == null) {
                if (similar) continue;
                return false;
            }
            Object v1 = otherObject.eGet(f);
            Object v2 = thisObject.eGet(f);
            if (v1 == null && v2 == null) continue;
            if (v1 == null || v2 == null) {
                return false;
            }
            if (v1.equals(v2)) continue;
            if (ModelUtil.isStringWrapper(v1) && ModelUtil.isStringWrapper(v2)) {
                v1 = ModelUtil.getStringWrapperValue(v1);
                v2 = ModelUtil.getStringWrapperValue(v2);
                if (v1 == null && v2 == null) continue;
                if (v1 == null || v2 == null) {
                    return false;
                }
                if (v1.equals(v2)) {
                    continue;
                }
            } else if (v1 instanceof EObject && v2 instanceof EObject && (adapter = ExtendedPropertiesAdapter.adapt((EObject)v1)) != null && adapter.getObjectDescriptor().compare((EObject)v2, similar)) continue;
            return false;
        }
        return true;
    }
}

