/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Enumeration;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.internal.core.model.Buffer;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.util.LRUCache;
import org.eclipse.cdt.internal.core.util.OverflowingLRUCache;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class BufferManager
implements IBufferFactory {
    protected static BufferManager DEFAULT_BUFFER_MANAGER;
    protected OverflowingLRUCache<IOpenable, IBuffer> openBuffers = new BufferCache<IOpenable>(60);

    protected void addBuffer(IBuffer buffer) {
        this.openBuffers.put(buffer.getOwner(), buffer);
    }

    @Override
    public IBuffer createBuffer(IOpenable owner) {
        ICElement element = (ICElement)((Object)owner);
        IResource resource = element.getResource();
        return new Buffer(resource instanceof IFile ? (IFile)resource : null, owner, element.isReadOnly());
    }

    public IBuffer getBuffer(IOpenable owner) {
        return (IBuffer)this.openBuffers.get(owner);
    }

    public IBufferFactory getDefaultBufferFactory() {
        return this;
    }

    public static synchronized BufferManager getDefaultBufferManager() {
        if (DEFAULT_BUFFER_MANAGER == null) {
            DEFAULT_BUFFER_MANAGER = new BufferManager();
        }
        return DEFAULT_BUFFER_MANAGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<IBuffer> getOpenBuffers() {
        OverflowingLRUCache<IOpenable, IBuffer> overflowingLRUCache = this.openBuffers;
        synchronized (overflowingLRUCache) {
            this.openBuffers.shrink();
            return this.openBuffers.elements();
        }
    }

    protected void removeBuffer(IBuffer buffer) {
        this.openBuffers.remove(buffer.getOwner());
    }

    public class BufferCache<K>
    extends OverflowingLRUCache<K, IBuffer> {
        public BufferCache(int size) {
            super(size);
        }

        public BufferCache(int size, int overflow) {
            super(size, overflow);
        }

        @Override
        protected boolean close(LRUCache.LRUCacheEntry<K, IBuffer> entry) {
            IBuffer buffer = (IBuffer)entry._fValue;
            if (buffer.hasUnsavedChanges()) {
                return false;
            }
            buffer.close();
            return true;
        }

        @Override
        protected OverflowingLRUCache<K, IBuffer> newInstance(int size, int overflow) {
            return new BufferCache<K>(size, overflow);
        }
    }
}

