/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.internal.core.parser;

import java.util.List;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.tcl.core.extensions.ISourceElementRequestVisitorExtension;
import org.eclipse.dltk.tcl.internal.parser.TclSourceElementRequestVisitor;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclFieldDeclaration;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclMethodCallStatement;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclProcCallStatement;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclVariableDeclaration;

public class XOTclSourceElementRequestVisitorExtension
implements ISourceElementRequestVisitorExtension {
    public int getModifiers(Declaration s) {
        if ((s.getModifiers() & 0x100000) != 0) {
            return s.getModifiers();
        }
        return 0;
    }

    public boolean visit(Statement statement, TclSourceElementRequestVisitor original) {
        if (statement instanceof XOTclMethodCallStatement) {
            CallArgumentsList arguments;
            List childs;
            XOTclMethodCallStatement call = (XOTclMethodCallStatement)statement;
            SimpleReference callName = call.getCallName();
            int len = 0;
            if (call.getArgs() != null && (childs = (arguments = call.getArgs()).getChilds()) != null) {
                len = childs.size();
            }
            original.getRequestor().acceptMethodReference(callName.getName(), len, call.sourceStart(), call.sourceEnd());
            return true;
        }
        if (statement instanceof XOTclProcCallStatement) {
            XOTclProcCallStatement call = (XOTclProcCallStatement)statement;
            SimpleReference callName = call.getCallName();
            int len = 0;
            original.getRequestor().acceptMethodReference(callName.getName(), len, call.sourceStart(), call.sourceEnd());
            return true;
        }
        return false;
    }

    public TclSourceElementRequestVisitor.ExitFromType getExitExtended(MethodDeclaration method, TclSourceElementRequestVisitor original) {
        String tName = method.getDeclaringTypeName();
        if (tName == null) {
            tName = "";
        }
        return original.resolveType((Declaration)method, String.valueOf(tName) + "::dummy", false);
    }

    public boolean extendedExitRequired(MethodDeclaration method, TclSourceElementRequestVisitor original) {
        return (method.getModifiers() & 0x100000) != 0;
    }

    public TclSourceElementRequestVisitor.ExitFromType processField(FieldDeclaration decl, TclSourceElementRequestVisitor original) {
        if ((decl.getModifiers() & 0x100000) != 0 && decl instanceof XOTclVariableDeclaration) {
            XOTclFieldDeclaration field = (XOTclFieldDeclaration)decl;
            String tName = field.getDeclaringTypeName();
            if (tName == null) {
                tName = "";
            }
            return original.resolveType((Declaration)field, String.valueOf(tName) + "::dummy", false);
        }
        return null;
    }

    public boolean skipMethod(MethodDeclaration method, TclSourceElementRequestVisitor tclSourceElementRequestVisitor) {
        return false;
    }

    public boolean isConstructor(MethodDeclaration declaration) {
        return false;
    }
}

