/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.repositories;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchChangedEvent;
import org.eclipse.emf.cdo.common.branch.CDOBranchCreationContext;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDGenerator;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.explorer.CDOExplorerManager;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryElement;
import org.eclipse.emf.cdo.internal.explorer.AbstractElement;
import org.eclipse.emf.cdo.internal.explorer.bundle.OM;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryManagerImpl;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.ConsumerWithException;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.UUIDGenerator;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.security.CredentialsUpdateOperation;
import org.eclipse.net4j.util.security.ICredentialsProvider;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.IPasswordCredentialsUpdate;
import org.eclipse.net4j.util.security.IPasswordCredentialsUpdateProvider;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.eclipse.net4j.util.security.SecurityUtil;

public abstract class CDORepositoryImpl
extends AbstractElement
implements CDORepository {
    public static final String PROP_NAME = "name";
    public static final String PROP_REALM = "realm";
    public static final String REPOSITORY_KEY = CDORepository.class.getName();
    private static final boolean READABLE_IDS = OMPlatform.INSTANCE.isProperty("cdo.explorer.readableIDs");
    private static final boolean SET_USER_NAME = OMPlatform.INSTANCE.isProperty("cdo.explorer.setUserName");
    private static final String VIEW_CONFIGURATOR_TYPE = OMPlatform.INSTANCE.getProperty("cdo.explorer.viewConfiguratorType", "checkout");
    private final Set<CDOCheckout> checkouts = new HashSet<CDOCheckout>();
    private final Set<CDOCheckout> openCheckouts = new HashSet<CDOCheckout>();
    private final IListener branchManagerListener = new IListener(){

        public void notifyEvent(IEvent event) {
            CDORepositoryManagerImpl manager;
            CDOBranchChangedEvent e;
            if (event instanceof CDOBranchChangedEvent && (e = (CDOBranchChangedEvent)event).getChangeKind() == CDOBranchChangedEvent.ChangeKind.RENAMED && (manager = CDORepositoryImpl.this.getManager()) != null) {
                manager.fireElementChangedEvent(CDOExplorerManager.ElementsChangedEvent.StructuralImpact.NONE, e.getBranch());
            }
        }
    };
    private final IListener mainBranchListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof IContainerEvent) {
                IContainerEvent e = (IContainerEvent)event;
                CDORepositoryImpl.this.fireEvent((IEvent)new ContainerEvent((IContainer)CDORepositoryImpl.this, Arrays.asList(e.getDeltas())));
            }
        }
    };
    private final IListener sessionReleaser = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            CDORepositoryImpl.this.releaseSession();
        }
    };
    private String name;
    private CDORepository.VersioningMode versioningMode;
    private CDORepository.IDGeneration idGeneration;
    private String realm;
    private CDORepository.State state = CDORepository.State.Disconnected;
    private boolean explicitlyConnected;
    private int sessionRefCount;
    private CDOSession session;
    public static final String PROP_VERSIONING_MODE = "versioningMode";
    public static final String PROP_ID_GENERATION = "idGeneration";

    public CDORepositoryManagerImpl getManager() {
        return OM.getRepositoryManager();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final CDORepository.VersioningMode getVersioningMode() {
        return this.versioningMode;
    }

    @Override
    public final CDORepository.IDGeneration getIDGeneration() {
        return this.idGeneration;
    }

    @Override
    public IPasswordCredentials getCredentials() {
        return this.getCredentials(null);
    }

    public IPasswordCredentials getCredentials(String realm) {
        IPasswordCredentials[] result = new IPasswordCredentials[1];
        this.withSecureNode(false, (ConsumerWithException<ISecurePreferences, Exception>)((ConsumerWithException)node -> {
            String userID = node.get("username", null);
            if (!StringUtil.isEmpty((String)userID)) {
                String password = node.get("password", null);
                iPasswordCredentialsArray[0] = new PasswordCredentials(userID, password);
            }
        }));
        return result[0];
    }

    @Override
    public void setCredentials(IPasswordCredentials credentials) {
        if (credentials == null) {
            this.withSecureNode(false, (ConsumerWithException<ISecurePreferences, Exception>)((ConsumerWithException)node -> {
                node.removeNode();
                node.flush();
            }));
            return;
        }
        String password = SecurityUtil.toString((char[])credentials.getPassword());
        this.withSecureNode(true, (ConsumerWithException<ISecurePreferences, Exception>)((ConsumerWithException)node -> {
            node.put("uri", this.getURI(), false);
            node.put("username", credentials.getUserID(), false);
            if (password == null) {
                node.remove("password");
            } else {
                node.put("password", password, true);
            }
            node.flush();
        }));
    }

    public IPasswordCredentialsUpdate getCredentialsUpdate(String userID, CredentialsUpdateOperation operation) {
        return this.getCredentialsUpdate(null, userID, operation);
    }

    public IPasswordCredentialsUpdate getCredentialsUpdate(String realm, String userID, CredentialsUpdateOperation operation) {
        IManagedContainer container = this.getContainer();
        ICredentialsProvider provider = (ICredentialsProvider)container.getElementOrNull("org.eclipse.net4j.util.security.credentialsProviders", "cdo-explorer", null);
        if (provider == null && (provider = (ICredentialsProvider)container.getElementOrNull("org.eclipse.net4j.util.security.credentialsProviders", "interactive", null)) == null) {
            provider = (ICredentialsProvider)container.getElementOrNull("org.eclipse.net4j.util.security.credentialsProviders", "default", null);
        }
        if (provider instanceof IPasswordCredentialsUpdateProvider) {
            return ((IPasswordCredentialsUpdateProvider)provider).getCredentialsUpdate(realm, userID, operation);
        }
        return null;
    }

    public boolean isInteractive() {
        return false;
    }

    @Override
    public final CDORepository.State getState() {
        return this.state;
    }

    @Override
    public final boolean isConnected() {
        return this.session != null;
    }

    @Override
    public final void connect() {
        this.explicitlyConnected = true;
        this.doConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnect() {
        CDORepositoryManagerImpl manager;
        boolean connected = false;
        CDOSession newSession = null;
        CDORepositoryImpl cDORepositoryImpl = this;
        synchronized (cDORepositoryImpl) {
            if (!this.isConnected()) {
                try {
                    this.state = CDORepository.State.Connecting;
                    this.session = this.openSession();
                    IRegistry properties = this.session.properties();
                    properties.put((Object)REPOSITORY_KEY, (Object)this);
                    properties.put((Object)"org.eclipse.emf.cdo.viewConfiguratorType", (Object)VIEW_CONFIGURATOR_TYPE);
                    this.session.addListener((IListener)new LifecycleEventAdapter(){

                        protected void onDeactivated(ILifecycle lifecycle) {
                            CDORepositoryImpl.this.explicitlyConnected = false;
                            CDORepositoryImpl.this.doDisconnect(true);
                        }
                    });
                    CDOBranchManager branchManager = this.session.getBranchManager();
                    branchManager.addListener(this.branchManagerListener);
                    CDOBranch mainBranch = branchManager.getMainBranch();
                    mainBranch.addListener(this.mainBranchListener);
                    newSession = this.session;
                    this.state = CDORepository.State.Connected;
                }
                catch (Error | RuntimeException ex) {
                    this.state = CDORepository.State.Disconnected;
                    throw ex;
                }
                connected = true;
            }
        }
        if (connected && (manager = this.getManager()) != null) {
            manager.fireRepositoryConnectionEvent(this, newSession, true);
        }
    }

    @Override
    public final void disconnect() {
        this.disconnect(false);
    }

    public final void disconnect(boolean force) {
        this.explicitlyConnected = false;
        this.doDisconnect(force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect(boolean force) {
        CDORepositoryManagerImpl manager;
        if (!force && (this.explicitlyConnected || this.sessionRefCount != 0)) {
            return;
        }
        boolean disconnected = false;
        CDOSession oldSession = null;
        CDORepositoryImpl cDORepositoryImpl = this;
        synchronized (cDORepositoryImpl) {
            if (this.isConnected()) {
                this.state = CDORepository.State.Disconnecting;
                oldSession = this.session;
                try {
                    this.closeSession();
                }
                finally {
                    this.session = null;
                    this.sessionRefCount = 0;
                    this.state = CDORepository.State.Disconnected;
                }
                disconnected = true;
            }
        }
        if (disconnected && (manager = this.getManager()) != null) {
            manager.fireRepositoryConnectionEvent(this, oldSession, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnectIfUnused() {
        Set<CDOCheckout> set = this.checkouts;
        synchronized (set) {
            if (this.openCheckouts.isEmpty()) {
                this.doDisconnect(false);
            }
        }
    }

    @Override
    public final CDOSession getSession() {
        return this.session;
    }

    @Override
    public CDOSession acquireSession() {
        ++this.sessionRefCount;
        this.doConnect();
        return this.session;
    }

    @Override
    public void releaseSession() {
        --this.sessionRefCount;
        this.doDisconnect(false);
    }

    public CDOTransaction openTransaction(CDOBranchPoint target, ResourceSet resourceSet) {
        CDOSession session = this.acquireSession();
        CDOTransaction transaction = session.openTransaction(target, resourceSet);
        transaction.addListener(this.sessionReleaser);
        return transaction;
    }

    public CDOTransaction openTransaction(String durableLockingID, ResourceSet resourceSet) {
        CDOSession session = this.acquireSession();
        CDOTransaction transaction = session.openTransaction(durableLockingID, resourceSet);
        transaction.addListener(this.sessionReleaser);
        return transaction;
    }

    public CDOView openView(CDOBranchPoint target, ResourceSet resourceSet) {
        CDOSession session = this.acquireSession();
        CDOView view = session.openView(target, resourceSet);
        view.addListener(this.sessionReleaser);
        return view;
    }

    public CDOView openView(String durableLockingID, ResourceSet resourceSet) {
        CDOSession session = this.acquireSession();
        CDOView view = session.openView(durableLockingID, resourceSet);
        view.addListener(this.sessionReleaser);
        return view;
    }

    @Override
    public void delete(boolean deleteContents) {
        this.disconnect();
        this.setCredentials(null);
        CDORepositoryManagerImpl manager = this.getManager();
        if (manager != null) {
            manager.removeElement(this);
        }
        super.delete(deleteContents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CDOCheckout[] getCheckouts() {
        Set<CDOCheckout> set = this.checkouts;
        synchronized (set) {
            return this.checkouts.toArray(new CDOCheckout[this.checkouts.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCheckout(CDOCheckout checkout) {
        Set<CDOCheckout> set = this.checkouts;
        synchronized (set) {
            this.checkouts.add(checkout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCheckout(CDOCheckout checkout) {
        Set<CDOCheckout> set = this.checkouts;
        synchronized (set) {
            this.checkouts.remove(checkout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CDOSession openCheckout(CDOCheckout checkout) {
        this.connect();
        Set<CDOCheckout> set = this.checkouts;
        synchronized (set) {
            this.openCheckouts.add(checkout);
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeCheckout(CDOCheckout checkout) {
        Set<CDOCheckout> set = this.checkouts;
        synchronized (set) {
            this.openCheckouts.remove(checkout);
        }
    }

    public final boolean isEmpty() {
        if (this.isConnected()) {
            return this.session.getBranchManager().getMainBranch().isEmpty();
        }
        return false;
    }

    public final CDOBranch[] getElements() {
        if (this.isConnected()) {
            return this.session.getBranchManager().getMainBranch().getBranches();
        }
        return new CDOBranch[0];
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (this.isConnected()) {
            if (adapter == CDOSession.class) {
                return this.session;
            }
            if (adapter == CDOBranchCreationContext.class && this.session.getRepositoryInfo().isSupportingBranches()) {
                return new CDOBranchCreationContext(){

                    public CDOBranchPoint getBase() {
                        return CDORepositoryImpl.this.session.getBranchManager().getMainBranch().getHead();
                    }
                };
            }
        }
        if (adapter == CDORepositoryElement.class) {
            return new CDORepositoryElement(){

                @Override
                public CDORepository getRepository() {
                    return CDORepositoryImpl.this;
                }

                @Override
                public int getBranchID() {
                    return 0;
                }

                public long getTimeStamp() {
                    return 0L;
                }

                @Override
                public CDOID getObjectID() {
                    return null;
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    protected void init(File folder, String type, Properties properties) {
        super.init(folder, type, properties);
        this.name = properties.getProperty(PROP_NAME);
        String versioningModeProperty = properties.getProperty(PROP_VERSIONING_MODE);
        this.versioningMode = versioningModeProperty == null ? null : CDORepository.VersioningMode.valueOf(versioningModeProperty);
        String idGenerationProperty = properties.getProperty(PROP_ID_GENERATION);
        this.idGeneration = idGenerationProperty == null ? null : CDORepository.IDGeneration.valueOf(idGenerationProperty);
        this.realm = properties.getProperty(PROP_REALM);
    }

    @Override
    protected void collectProperties(Properties properties) {
        super.collectProperties(properties);
        properties.setProperty(PROP_NAME, this.name);
        if (this.versioningMode != null) {
            properties.setProperty(PROP_VERSIONING_MODE, this.versioningMode.toString());
        }
        if (this.idGeneration != null) {
            properties.setProperty(PROP_ID_GENERATION, this.idGeneration.toString());
        }
        if (this.realm != null) {
            properties.setProperty(PROP_REALM, this.realm);
        }
    }

    protected IConnector getConnector() {
        IManagedContainer container = this.getContainer();
        return Net4jUtil.getConnector((IManagedContainer)container, (String)this.getConnectorType(), (String)this.getConnectorDescription());
    }

    protected CDOSessionConfiguration createSessionConfiguration() {
        IConnector connector = this.getConnector();
        CDONet4jSessionConfiguration config = CDONet4jUtil.createNet4jSessionConfiguration();
        config.setConnector(connector);
        config.setRepositoryName(this.name);
        if (READABLE_IDS) {
            config.setIDGenerator(new CDOIDGenerator(){
                private final UUIDGenerator decoder = new UUIDGenerator();
                private Map<EClass, AtomicInteger> counters;
                private int typeCounter;

                public CDOID generateCDOID(EObject object) {
                    byte[] value;
                    String encoded;
                    EClass eClass;
                    String type;
                    if (this.counters == null) {
                        this.counters = new HashMap<EClass, AtomicInteger>();
                        CDOView view = CDOUtil.getView((Notifier)object);
                        view.getSession().getRevisionManager().handleRevisions(null, null, false, 0L, false, new CDORevisionHandler(){

                            public boolean handleRevision(CDORevision revision) {
                                EClass eClass = revision.getEClass();
                                AtomicInteger counter = this.getCounter(eClass);
                                String id = revision.getID().toString();
                                id = id.substring(0, id.length() - "A".length());
                                int counterValue = Integer.parseInt(id = id.substring(id.lastIndexOf(95) + 1));
                                if (counterValue > counter.get()) {
                                    counter.set(counterValue);
                                }
                                return true;
                            }
                        });
                    }
                    if ((type = (eClass = object.eClass()).getName()).length() > 16) {
                        String suffix = "_" + ++this.typeCounter;
                        type = String.valueOf(type.substring(0, 16 - suffix.length())) + suffix;
                        System.out.println(String.valueOf(eClass.getName()) + " --> " + type);
                    }
                    type = "_" + type;
                    AtomicInteger counter = this.getCounter(eClass);
                    String str = "_" + counter.incrementAndGet();
                    String id = String.valueOf(type) + "____________________________________".substring(0, 22 - type.length() - str.length()) + str + "A";
                    if ("_CDOResource_________5A".equals(id)) {
                        System.out.println();
                    }
                    if (!(encoded = this.decoder.encode(value = this.decoder.decode(id))).equals(id)) {
                        throw new IllegalStateException();
                    }
                    return CDOIDUtil.createUUID((byte[])value);
                }

                private AtomicInteger getCounter(EClass eClass) {
                    AtomicInteger counter = this.counters.get(eClass);
                    if (counter == null) {
                        counter = new AtomicInteger();
                        this.counters.put(eClass, counter);
                    }
                    return counter;
                }

                public void reset() {
                }
            });
        }
        return config;
    }

    public CDOSession openSession() {
        String userName;
        CDOSessionConfiguration sessionConfiguration = this.createSessionConfiguration();
        sessionConfiguration.setPassiveUpdateEnabled(true);
        sessionConfiguration.setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode.CHANGES);
        sessionConfiguration.setCredentialsProvider((IPasswordCredentialsProvider)this);
        CDOSession session = sessionConfiguration.openSession();
        session.options().setGeneratedPackageEmulationEnabled(true);
        if (SET_USER_NAME && StringUtil.isEmpty((String)session.getUserID()) && !StringUtil.isEmpty((String)(userName = System.getProperty("user.name")))) {
            ((InternalCDOSession)session).setUserID(userName);
        }
        return session;
    }

    protected void closeSession() {
        this.session.close();
    }

    private void withSecureNode(boolean createOnDemand, ConsumerWithException<ISecurePreferences, Exception> consumer) {
        try {
            ISecurePreferences securePreferences = CDORepositoryImpl.getSecurePreferences();
            if (securePreferences != null) {
                String path = String.valueOf(OM.getSecurePath()) + "/" + this.getID().replace('/', '_');
                if (createOnDemand || securePreferences.nodeExists(path)) {
                    ISecurePreferences node = securePreferences.node(path);
                    consumer.accept((Object)node);
                }
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    private static ISecurePreferences getSecurePreferences() throws IOException {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("org.eclipse.equinox.security.storage.promptUser", Boolean.FALSE);
        ISecurePreferences result = SecurePreferencesFactory.open(null, options);
        if (result != null) {
            try {
                long timestamp;
                long lastModified;
                Object root = ReflectUtil.getValue((String)"node", (Object)result);
                root = ReflectUtil.invokeMethod((String)"getRoot", (Object)root);
                boolean modified = (Boolean)ReflectUtil.invokeMethod((String)"isModified", (Object)root);
                if (!modified && (lastModified = ((Long)ReflectUtil.invokeMethod((String)"getLastModified", (Object)root)).longValue()) != (timestamp = ((Long)ReflectUtil.getValue((String)"timestamp", (Object)root)).longValue())) {
                    ReflectUtil.invokeMethod((String)"load", (Object)root);
                }
            }
            catch (Throwable ex) {
                OM.LOG.error(ex);
            }
        }
        return result;
    }
}

