/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalSession;

public class RefreshSessionIndication
extends CDOServerReadIndication {
    private Map<CDOBranch, List<CDORevisionKey>> viewedRevisions = new HashMap<CDOBranch, List<CDORevisionKey>>();
    private long lastUpdateTime;
    private int initialChunkSize;
    private boolean enablePassiveUpdates;

    public RefreshSessionIndication(CDOServerProtocol protocol) {
        this(protocol, 19);
    }

    protected RefreshSessionIndication(CDOServerProtocol protocol, short signalID) {
        super(protocol, signalID);
    }

    public Map<CDOBranch, List<CDORevisionKey>> getViewedRevisions() {
        return this.viewedRevisions;
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.lastUpdateTime = in.readXLong();
        this.initialChunkSize = in.readXInt();
        this.enablePassiveUpdates = in.readBoolean();
        int branches = in.readXInt();
        int i = 0;
        while (i < branches) {
            CDOBranch branch = in.readCDOBranch();
            ArrayList<CDORevisionKey> revisions = new ArrayList<CDORevisionKey>();
            this.viewedRevisions.put(branch, revisions);
            int size = in.readXInt();
            int j = 0;
            while (j < size) {
                CDORevisionKey revision = in.readCDORevisionKey();
                revisions.add(revision);
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        long lastCommitTimeStamp = this.getRepository().getLastCommitTimeStamp();
        out.writeXLong(lastCommitTimeStamp);
        this.writePackageUnits(out, lastCommitTimeStamp);
        this.writeRevisions(out);
        this.respondingDone();
    }

    protected void respondingDone() {
        InternalSession session = this.getSession();
        session.setPassiveUpdateEnabled(this.enablePassiveUpdates);
    }

    protected void writPackageUnit(CDODataOutput out, InternalCDOPackageUnit packageUnit) throws IOException {
        out.writeByte(1);
        out.writeCDOPackageUnit((CDOPackageUnit)packageUnit, false);
    }

    @Deprecated
    protected void writeChangedObject(CDODataOutput out, InternalCDORevision revision) throws IOException {
        this.writeChangedObject(out, revision, null);
    }

    protected void writeChangedObject(CDODataOutput out, InternalCDORevision revision, CDOBranchPoint securityContext) throws IOException {
        out.writeByte(2);
        out.writeCDORevision((CDORevision)revision, this.initialChunkSize, securityContext);
    }

    protected void writeDetachedObject(CDODataOutput out, CDORevisionKey key) throws IOException {
        out.writeByte(3);
        out.writeCDORevisionKey(key);
    }

    private void writePackageUnits(CDODataOutput out, long lastCommitTimeStamp) throws IOException {
        InternalCDOPackageUnit[] packageUnits;
        InternalCDOPackageRegistry packageRegistry = this.getRepository().getPackageRegistry();
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits = packageRegistry.getPackageUnits(this.lastUpdateTime + 1L, lastCommitTimeStamp);
        int n = packageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
            this.writPackageUnit(out, packageUnit);
            ++n2;
        }
    }

    private void writeRevisions(CDODataOutput out) throws IOException {
        InternalCDORevisionManager revisionManager = this.getRepository().getRevisionManager();
        SyntheticCDORevision[] synthetics = new SyntheticCDORevision[1];
        for (Map.Entry<CDOBranch, List<CDORevisionKey>> entry : this.viewedRevisions.entrySet()) {
            CDOBranch branch = entry.getKey();
            CDOBranchPoint head = branch.getHead();
            for (CDORevisionKey key : entry.getValue()) {
                CDOID id = key.getID();
                synthetics[0] = null;
                InternalCDORevision revision = revisionManager.getRevision(id, head, -1, 0, true, synthetics);
                if (revision == null) {
                    this.writeDetachedObject(out, (CDORevisionKey)synthetics[0]);
                    continue;
                }
                if (!RefreshSessionIndication.hasChanged(key, (CDORevisionKey)revision)) continue;
                this.writeChangedObject(out, revision, head);
            }
        }
        out.writeByte(0);
    }

    private static boolean hasChanged(CDORevisionKey oldKey, CDORevisionKey newKey) {
        return oldKey.getBranch() != newKey.getBranch() || oldKey.getVersion() != newKey.getVersion();
    }
}

