/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.internal.merge;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.storage.WorkspaceFileRevision;
import org.eclipse.egit.core.synchronize.GitRemoteResource;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantFileRevision;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.storage.GitLocalResourceVariant;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.diff.provider.ThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.provider.ResourceDiff;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.core.mapping.ResourceVariantFileRevision;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;

public class GitSyncInfoToDiffConverter
extends SyncInfoToDiffConverter {
    private GitResourceVariantTreeProvider variantTreeProvider;

    public GitSyncInfoToDiffConverter(GitResourceVariantTreeProvider variantTreeProvider) {
        this.variantTreeProvider = variantTreeProvider;
    }

    public IDiff getDeltaFor(SyncInfo info) {
        if (info.getComparator().isThreeWay()) {
            ITwoWayDiff local = this.getLocalDelta(info);
            ITwoWayDiff remote = this.getRemoteDelta(info);
            return new ThreeWayDiff(local, remote);
        }
        if (info.getKind() != 0) {
            IResourceVariant remote = info.getRemote();
            IResource local = info.getLocal();
            int kind = remote == null ? 2 : (!local.exists() ? 1 : 4);
            if (local.getType() == 1) {
                IFileRevision after = this.asFileState(remote);
                IFileRevision before = this.getLocalFileRevision((IFile)local);
                return new ResourceDiff(info.getLocal(), kind, 0, before, after);
            }
            return new ResourceDiff(info.getLocal(), kind);
        }
        return null;
    }

    private ITwoWayDiff getLocalDelta(SyncInfo info) {
        int direction = SyncInfo.getDirection((int)info.getKind());
        if (direction == 4 || direction == 12) {
            IResourceVariant ancestor = info.getBase();
            IResource local = info.getLocal();
            int kind = ancestor == null ? 1 : (!local.exists() ? 2 : 4);
            if (local.getType() == 1) {
                IFileRevision before = this.asFileState(ancestor);
                IFileRevision after = this.getLocalFileRevision((IFile)local);
                return new ResourceDiff(info.getLocal(), kind, 0, before, after);
            }
            return new ResourceDiff(info.getLocal(), kind);
        }
        return null;
    }

    public IFileRevision getLocalFileRevision(IFile local) {
        try {
            return this.asFileState(this.variantTreeProvider.getSourceTree().getResourceVariant((IResource)local));
        }
        catch (TeamException e) {
            String error = NLS.bind((String)CoreText.GitResourceVariantTreeSubscriber_CouldNotFindSourceVariant, (Object)local.getName());
            Activator.logError((String)error, (Throwable)e);
            return WorkspaceFileRevision.forFile((Repository)this.variantTreeProvider.getRepository(), (IResource)local);
        }
    }

    private ITwoWayDiff getRemoteDelta(SyncInfo info) {
        int direction = SyncInfo.getDirection((int)info.getKind());
        if (direction == 8 || direction == 12) {
            IResourceVariant ancestor = info.getBase();
            IResourceVariant remote = info.getRemote();
            int kind = ancestor == null ? 1 : (remote == null ? 2 : 4);
            if (info.getLocal().getType() == 1) {
                IFileRevision before = this.asFileState(ancestor);
                IFileRevision after = this.asFileState(remote);
                return new ResourceDiff(info.getLocal(), kind, 0, before, after);
            }
            return new ResourceDiff(info.getLocal(), kind);
        }
        return null;
    }

    private IFileRevision asFileState(IResourceVariant variant) {
        if (variant == null) {
            return null;
        }
        if (variant instanceof GitLocalResourceVariant) {
            return WorkspaceFileRevision.forFile((Repository)this.variantTreeProvider.getRepository(), (IResource)((GitLocalResourceVariant)variant).getResource());
        }
        return this.asFileRevision(variant);
    }

    protected ResourceVariantFileRevision asFileRevision(IResourceVariant variant) {
        if (variant instanceof GitRemoteResource) {
            return new GitResourceVariantFileRevision((GitRemoteResource)variant);
        }
        return new ResourceVariantFileRevision(variant);
    }
}

