/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.ui.provider;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.EmfParsleyActivator;
import org.eclipse.emf.parsley.runtime.ui.IImageHelper;
import org.eclipse.emf.parsley.runtime.util.PolymorphicDispatcher;
import org.eclipse.emf.parsley.runtime.util.PolymorphicDispatcherExtensions;
import org.eclipse.emf.parsley.util.EcoreUtil2;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class TableColumnLabelProvider
extends ColumnLabelProvider {
    private EStructuralFeature eStructuralFeature;
    private ILabelProvider labelProvider;
    @Inject
    private IImageHelper imageHelper;
    private PolymorphicDispatcher<Font> fontDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"rowFont", (int)1, (int)1, (Object)((Object)this));
    private PolymorphicDispatcher<Color> foregroundDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"rowForeground", (int)1, (int)1, (Object)((Object)this));
    private PolymorphicDispatcher<Color> backgroundDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"rowBackground", (int)1, (int)1, (Object)((Object)this));

    @Inject
    public TableColumnLabelProvider() {
    }

    public EStructuralFeature geteStructuralFeature() {
        return this.eStructuralFeature;
    }

    public void seteStructuralFeature(EStructuralFeature eStructuralFeature) {
        this.eStructuralFeature = eStructuralFeature;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Inject
    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        String ret = this.polymorphicGetText(element, this.geteStructuralFeature());
        if (ret != null) {
            return ret;
        }
        try {
            return this.defaultGetTextForFeatureValue(element);
        }
        catch (AssertionError e) {
            return this.logErrorAndReturnEmptyString((Throwable)((Object)e));
        }
        catch (RuntimeException e) {
            return this.logErrorAndReturnEmptyString(e);
        }
    }

    protected String defaultGetTextForFeatureValue(Object element) {
        Object featureValue = this.getFeatureValue(element);
        return featureValue != null ? this.getLabelProvider().getText(featureValue) : "";
    }

    protected String logErrorAndReturnEmptyString(Throwable e) {
        EmfParsleyActivator.logError("TableColumnLabelProvider.getText", e);
        return "";
    }

    protected Object getFeatureValue(Object element) {
        EObject eObject = (EObject)element;
        return EcoreUtil2.safeEGet(eObject, this.geteStructuralFeature());
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        Image ret = this.polymorphicGetImage(element, this.geteStructuralFeature());
        return ret;
    }

    public Font getFont(Object element) {
        if (element == null) {
            return null;
        }
        Font forFeature = (Font)this.invokePolymorphicDispatcher(element, this.geteStructuralFeature(), "font_");
        if (forFeature != null) {
            return forFeature;
        }
        return (Font)this.fontDispatcher.invoke(new Object[]{element});
    }

    public Font rowFont(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element == null) {
            return null;
        }
        Color forFeature = (Color)this.invokePolymorphicDispatcher(element, this.geteStructuralFeature(), "foreground_");
        if (forFeature != null) {
            return forFeature;
        }
        return (Color)this.foregroundDispatcher.invoke(new Object[]{element});
    }

    public Color rowForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        if (element == null) {
            return null;
        }
        Color forFeature = (Color)this.invokePolymorphicDispatcher(element, this.geteStructuralFeature(), "background_");
        if (forFeature != null) {
            return forFeature;
        }
        return (Color)this.backgroundDispatcher.invoke(new Object[]{element});
    }

    public Color rowBackground(Object element) {
        return null;
    }

    protected String polymorphicGetText(Object element, EStructuralFeature feature) {
        return (String)this.invokePolymorphicDispatcher(element, feature, "text_");
    }

    protected Image polymorphicGetImage(Object element, EStructuralFeature feature) {
        Object invoke = this.invokePolymorphicDispatcher(element, feature, "image_");
        if (invoke != null) {
            return this.imageHelper.convertToImage(invoke);
        }
        return null;
    }

    protected <T> T invokePolymorphicDispatcher(Object element, EStructuralFeature feature, String prefix) {
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            return (T)PolymorphicDispatcherExtensions.polymorphicInvokeBasedOnFeature((Object)((Object)this), (EClass)eObject.eClass(), (EStructuralFeature)feature, (String)prefix, (Object[])new Object[]{element});
        }
        String methodName = String.valueOf(prefix) + feature.getEContainingClass().getName() + "_" + feature.getName();
        Predicate predicate = PolymorphicDispatcher.Predicates.forName((String)methodName, (int)1);
        return (T)PolymorphicDispatcherExtensions.createPolymorphicDispatcher((Object)((Object)this), (Predicate)predicate).invoke(new Object[]{element});
    }
}

