/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.actions;

import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.transform.Transform;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.mvc.fx.handlers.PanningSupport;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.policies.ViewportPolicy;
import org.eclipse.gef.mvc.fx.ui.actions.AbstractViewerAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Event;

public abstract class AbstractZoomAction
extends AbstractViewerAction {
    private PanningSupport panningSupport = new PanningSupport();

    protected AbstractZoomAction(String text) {
        this(text, 1, null);
    }

    protected AbstractZoomAction(String text, int style, ImageDescriptor imageDescriptor) {
        super(text, style, imageDescriptor);
    }

    @Override
    protected ITransactionalOperation createOperation(Event event) {
        InfiniteCanvas infiniteCanvas = this.getInfiniteCanvas();
        if (infiniteCanvas == null) {
            throw new IllegalStateException("Cannot perform AbstractZoomAction, because no InfiniteCanvas can be determiend.");
        }
        AffineTransform contentTransform = FX2Geometry.toAffineTransform((Transform)infiniteCanvas.getContentTransform());
        double sx = this.determineZoomFactor(contentTransform.getScaleX(), event);
        Point2D pivotInScene = infiniteCanvas.localToScene(infiniteCanvas.getWidth() / 2.0, infiniteCanvas.getHeight() / 2.0);
        ViewportPolicy viewportPolicy = (ViewportPolicy)this.getViewer().getRootPart().getAdapter(ViewportPolicy.class);
        if (viewportPolicy == null) {
            throw new IllegalStateException("Cannot perform AbstractZoomAction, because no ViewportPolicy can be determined for the root part.");
        }
        viewportPolicy.init();
        if (this.isContentRestricted()) {
            this.panningSupport.removeFreeSpace(viewportPolicy, Pos.TOP_LEFT, true);
        }
        viewportPolicy.zoom(false, false, sx, pivotInScene.getX(), pivotInScene.getY());
        if (this.isContentRestricted()) {
            this.panningSupport.removeFreeSpace(viewportPolicy, Pos.BOTTOM_RIGHT, false);
        }
        return viewportPolicy.commit();
    }

    protected abstract double determineZoomFactor(double var1, Event var3);

    protected InfiniteCanvas getInfiniteCanvas() {
        Parent canvas = this.getViewer().getCanvas();
        if (canvas instanceof InfiniteCanvas) {
            return (InfiniteCanvas)canvas;
        }
        return null;
    }

    protected boolean isContentRestricted() {
        return false;
    }
}

