/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.actions;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.actions.AbstractOpenAction;
import org.eclipse.jst.j2ee.internal.actions.ComponentEditorInput;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.componentcore.ComponentArchiveOptions;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.ejb.provider.J2EEJavaClassProviderHelper;
import org.eclipse.jst.j2ee.internal.plugin.BinaryEditorUtilities;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsdd.BeanLink;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class OpenJ2EEResourceAction
extends AbstractOpenAction {
    public static final String ID = "org.eclipse.jst.j2ee.internal.internal.ui.actions.OpenJ2EEResourceAction";
    public static final String JAVA_EDITOR_ID = "org.eclipse.jst.j2ee.internal.internal.ejb.ui.java.EnterpriseBeanJavaEditor";
    public static final String BASE_JAVA_EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";
    protected static IEditorDescriptor javaEditorDescriptor;
    protected static IEditorDescriptor baseJavaEditorDescriptor;

    public OpenJ2EEResourceAction() {
        super(J2EEUIMessages.getResourceString("OpenJ2EEResourceAction.0"));
    }

    public String getID() {
        return ID;
    }

    public static IEditorDescriptor getJavaEditorDescriptor() {
        if (javaEditorDescriptor == null) {
            javaEditorDescriptor = OpenJ2EEResourceAction.findEditorDescriptor(JAVA_EDITOR_ID);
        }
        return javaEditorDescriptor;
    }

    public static IEditorDescriptor getBaseJavaEditorDescriptor() {
        if (baseJavaEditorDescriptor == null) {
            baseJavaEditorDescriptor = OpenJ2EEResourceAction.findEditorDescriptor(BASE_JAVA_EDITOR_ID);
        }
        return baseJavaEditorDescriptor;
    }

    protected void openAppropriateEditor(IVirtualComponent c) {
        if (c == null) {
            return;
        }
        IWorkbenchPage page = null;
        IEditorPart editor = null;
        try {
            JavaEEQuickPeek qp;
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            ComponentEditorInput editorInput = null;
            if (c.isBinary() && ((qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek((IVirtualComponent)c)).getJavaEEVersion() == 50 || qp.getJavaEEVersion() == 60 || qp.getType() == 2)) {
                String path = ((EObject)this.srcObject).eResource().getURI().toString();
                editorInput = BinaryEditorUtilities.getBinaryEditorInput(c, path);
            }
            if (editorInput == null) {
                editorInput = new ComponentEditorInput(c);
            }
            if ((editor = page.openEditor((IEditorInput)editorInput, this.currentDescriptor.getId())) instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)editor).selectReveal((ISelection)this.getStructuredSelection());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)J2EEUIMessages.getResourceString("Problems_Opening_Editor_ERROR_"), (String)e.getMessage());
        }
    }

    protected void openAppropriateEditor(IResource r) {
        if (r == null) {
            return;
        }
        IWorkbenchPage page = null;
        IEditorPart editor = null;
        try {
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (this.currentDescriptor != null && (editor = page.openEditor((IEditorInput)new FileEditorInput((IFile)r), this.currentDescriptor.getId())) instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)editor).selectReveal((ISelection)this.getStructuredSelection());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)J2EEUIMessages.getResourceString("Problems_Opening_Editor_ERROR_"), (String)e.getMessage());
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.srcObject instanceof J2EEJavaClassProviderHelper) {
            ((J2EEJavaClassProviderHelper)this.srcObject).openInEditor();
            return;
        }
        if (this.isEJB3BeanObject(this.srcObject)) {
            String name = "";
            if (this.srcObject instanceof SessionBean) {
                SessionBean bean = (SessionBean)this.srcObject;
                name = bean.getEjbClass();
            } else if (this.srcObject instanceof MessageDrivenBean) {
                MessageDrivenBean bean = (MessageDrivenBean)this.srcObject;
                name = bean.getEjbClass();
            } else if (this.srcObject instanceof EntityBean) {
                EntityBean bean = (EntityBean)this.srcObject;
                name = bean.getEjbClass();
            }
            this.openResourceInEditor(name, (EObject)this.srcObject);
            return;
        }
        if (this.srcObject instanceof org.eclipse.jst.javaee.web.Servlet) {
            String name = "";
            name = ((org.eclipse.jst.javaee.web.Servlet)this.srcObject).getServletClass();
            this.openResourceInEditor(name, (EObject)this.srcObject);
            return;
        }
        if (this.srcObject instanceof Filter) {
            String name = "";
            name = ((Filter)this.srcObject).getFilterClass();
            this.openResourceInEditor(name, (EObject)this.srcObject);
            return;
        }
        if (this.srcObject instanceof Listener) {
            String name = "";
            name = ((Listener)this.srcObject).getListenerClass();
            this.openResourceInEditor(name, (EObject)this.srcObject);
            return;
        }
        if (this.srcObject instanceof EObject) {
            EObject ro = (EObject)this.srcObject;
            IProject p = ProjectUtilities.getProject((EObject)ro);
            if (ro instanceof BeanLink) {
                this.openBeanLinkInJavaEditor((BeanLink)ro, p);
                return;
            }
            IFile resource = WorkbenchResourceHelper.getFile((EObject)((EObject)this.srcObject));
            if (resource != null && resource.exists()) {
                this.openAppropriateEditor((IResource)resource);
            } else if (ro.eResource() != null) {
                ModuleFile moduleFile = ArchiveUtil.getModuleFile((EObject)ro);
                if (moduleFile != null) {
                    ArchiveOptions options = moduleFile.getOptions();
                    if (options instanceof ComponentArchiveOptions) {
                        IVirtualComponent component = ((ComponentArchiveOptions)options).getComponent();
                        this.openAppropriateEditor(component);
                    }
                } else {
                    IVirtualComponent component;
                    IArchive archive = JavaEEArchiveUtilities.findArchive((Object)ro);
                    if (archive != null && (component = JavaEEArchiveUtilities.findComponent((IArchive)archive)) != null) {
                        this.openAppropriateEditor(component);
                    }
                }
            }
        } else if (this.srcObject instanceof Resource) {
            this.openAppropriateEditor((IResource)WorkbenchResourceHelper.getFile((Resource)((Resource)this.srcObject)));
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean updateSelection(IStructuredSelection s) {
        block23: {
            block26: {
                block27: {
                    block28: {
                        block25: {
                            block24: {
                                if (!super.updateSelection(s)) {
                                    return false;
                                }
                                obj = s.getFirstElement();
                                if (!(obj instanceof J2EEJavaClassProviderHelper)) break block24;
                                this.currentDescriptor = OpenJ2EEResourceAction.getJavaEditorDescriptor();
                                break block23;
                            }
                            if (!(obj instanceof BeanLink)) break block25;
                            this.currentDescriptor = OpenJ2EEResourceAction.getBaseJavaEditorDescriptor();
                            break block23;
                        }
                        if (this.isEJB3BeanObject(obj)) {
                            this.srcObject = obj;
                            return true;
                        }
                        if (obj instanceof org.eclipse.jst.javaee.web.Servlet || obj instanceof Filter || obj instanceof Listener) {
                            this.srcObject = obj;
                            return true;
                        }
                        if (!(obj instanceof EObject)) break block26;
                        registry = PlatformUI.getWorkbench().getEditorRegistry();
                        file = WorkbenchResourceHelper.getFile((EObject)((EObject)obj));
                        if (file == null) break block27;
                        if (!file.exists()) break block28;
                        contentType = IDE.getContentType((IFile)file);
                        this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
                        break block23;
                    }
                    this.currentDescriptor = null;
                    return false;
                }
                if (((EObject)obj).eResource() == null || (archive = JavaEEArchiveUtilities.findArchive((Object)(eObj = (EObject)obj))) == null || !archive.containsArchiveResource((IPath)(path = new Path(((EObject)obj).eResource().getURI().toString())))) break block23;
                stream = null;
                try {
                    resource = archive.getArchiveResource((IPath)path);
                    stream = resource.getInputStream();
                    type = Platform.getContentTypeManager().findContentTypeFor(stream, path.lastSegment());
                    this.currentDescriptor = registry.getDefaultEditor(path.lastSegment(), type);
                }
                catch (FileNotFoundException e) {
                    J2EEUIPlugin.logError(-1, e.getMessage(), e);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            J2EEUIPlugin.logError(-1, e.getMessage(), e);
                        }
                    }
                    break block23;
                }
                catch (IOException e) {
                    try {
                        J2EEUIPlugin.logError(-1, e.getMessage(), e);
                        break block23;
                    }
                    catch (Throwable var11_21) {
                        throw var11_21;
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                J2EEUIPlugin.logError(-1, e.getMessage(), e);
                            }
                        }
                    }
                }
                ** if (stream == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        J2EEUIPlugin.logError(-1, e.getMessage(), e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block23;
                }
            }
            if (obj instanceof Resource) {
                registry = PlatformUI.getWorkbench().getEditorRegistry();
                file = WorkbenchResourceHelper.getFile((Resource)((Resource)obj));
                contentType = IDE.getContentType((IFile)file);
                this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
            } else {
                this.currentDescriptor = null;
                return false;
            }
        }
        this.setAttributesFromDescriptor();
        this.srcObject = obj;
        return true;
    }

    private void openBeanLinkInJavaEditor(BeanLink link, IProject p) {
        EJBArtifactEdit artifactEdit;
        String linkName = null;
        JavaClass javaClass = null;
        IVirtualComponent comp = ComponentUtilities.findComponent((EObject)link);
        if (link instanceof EJBLink) {
            linkName = ((EJBLink)link).getEjbLink();
            artifactEdit = null;
            try {
                artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)comp);
                EJBJar ejbJar = artifactEdit.getEJBJar();
                if (ejbJar == null) {
                    return;
                }
                EnterpriseBean bean = ejbJar.getEnterpriseBeanNamed(linkName);
                if (bean == null) {
                    return;
                }
                javaClass = bean.getEjbClass();
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        linkName = ((ServletLink)link).getServletLink();
        artifactEdit = null;
        try {
            artifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)comp);
            WebApp webApp = artifactEdit.getWebApp();
            if (webApp == null) {
                return;
            }
            Servlet servlet = webApp.getServletNamed(linkName);
            if (servlet == null) {
                return;
            }
            javaClass = servlet.getServletClass();
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        try {
            J2EEEditorUtility.openInEditor(javaClass, p);
        }
        catch (Exception cantOpen) {
            J2EEUIPlugin.logError(-1, cantOpen.getMessage(), cantOpen);
        }
    }

    protected EObject getRootObject(Object obj) {
        if (obj instanceof EObject) {
            EObject refObj = (EObject)obj;
            while (refObj != null && refObj.eContainer() != null) {
                refObj = refObj.eContainer();
            }
            return refObj;
        }
        return null;
    }

    private boolean isEJB3BeanObject(Object obj) {
        boolean isBean = obj instanceof SessionBean || obj instanceof MessageDrivenBean || obj instanceof EntityBean;
        return isBean;
    }

    protected void openResourceInEditor(String name, EObject object) {
        IFile resource = WorkbenchResourceHelper.getFile((EObject)object);
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject.exists()) {
            IType type = null;
            try {
                if (name != null) {
                    type = javaProject.findType(name);
                }
                if (type != null) {
                    if (!type.isBinary()) {
                        ICompilationUnit cu = type.getCompilationUnit();
                        EditorUtility.openInEditor((Object)cu);
                    } else {
                        IOrdinaryClassFile classFile = type.getClassFile();
                        EditorUtility.openInEditor((Object)classFile);
                    }
                } else {
                    if (resource.exists() && resource.getType() == 1) {
                        IFile file = resource;
                        IContentType contentType = IDE.getContentType((IFile)file);
                        this.currentDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName(), contentType);
                    }
                    this.openAppropriateEditor((IResource)resource);
                }
            }
            catch (JavaModelException e) {
                J2EEUIPlugin.logError(-1, e.getMessage(), e);
            }
            catch (PartInitException e) {
                J2EEUIPlugin.logError(-1, e.getMessage(), e);
            }
        }
    }
}

