/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.newwizard;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.libra.warproducts.core.IWARProduct;
import org.eclipse.libra.warproducts.core.InfrastructureCreator;
import org.eclipse.libra.warproducts.core.WARProduct;
import org.eclipse.libra.warproducts.core.WARProductInitializer;
import org.eclipse.libra.warproducts.ui.newwizard.BaseWARProductCreationOperation;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;

public class WARProductFromConfigOperation
extends BaseWARProductCreationOperation {
    private IContainer productParent;
    private ILaunchConfiguration launchConfig;

    public WARProductFromConfigOperation(IFile file, ILaunchConfiguration config) {
        super(file);
        this.productParent = file.getParent();
        this.launchConfig = config;
    }

    protected void initializeProduct(IProduct product) {
        this.internalInitializeProduct(product);
        InfrastructureCreator creator = new InfrastructureCreator(this.productParent);
        this.createWebInfContent(creator);
        if (product instanceof WARProduct) {
            WARProduct warProduct = (WARProduct)product;
            warProduct.addLaunchIni(creator.getLaunchIniPath());
            warProduct.addWebXml(creator.getWebXmlPath());
            WARProductInitializer initializer = new WARProductInitializer((IWARProduct)warProduct);
            initializer.initialize();
        }
    }

    protected void internalInitializeProduct(IProduct product) {
        if (this.launchConfig != null) {
            try {
                IProductModelFactory factory = product.getModel().getFactory();
                this.handleApplication(product, factory);
                this.handleJRE(product);
                this.handlePluginModel(product, factory);
                this.handleVMArguments(product, factory);
            }
            catch (CoreException e) {
                PDEPlugin.logException((Throwable)e);
            }
        }
    }

    private void handleApplication(IProduct product, IProductModelFactory factory) throws CoreException {
        boolean useProduct = this.launchConfig.getAttribute("useProduct", false);
        if (useProduct) {
            String id = this.launchConfig.getAttribute("product", "");
            if (!id.equals("")) {
                this.initializeProductInfo(factory, product, id);
            }
        } else {
            String application = "application";
            String defaultApplication = TargetPlatform.getDefaultApplication();
            String appName = this.launchConfig.getAttribute(application, defaultApplication);
            product.setApplication(appName);
        }
    }

    private void handleJRE(IProduct product) throws CoreException {
        String JreContainerPathName = IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH;
        String jreString = this.launchConfig.getAttribute(JreContainerPathName, "");
        if (!jreString.equals("")) {
            Path jreContainerPath = new Path(jreString);
            IJREInfo jreInfo = product.getJREInfo();
            if (jreInfo == null) {
                jreInfo = product.getModel().getFactory().createJVMInfo();
            }
            jreInfo.setJREContainerPath(TargetPlatform.getOS(), (IPath)jreContainerPath);
            product.setJREInfo(jreInfo);
        }
    }

    private void handlePluginModel(IProduct product, IProductModelFactory factory) throws CoreException {
        String workspaceId = "selected_workspace_plugins";
        String targetId = "selected_target_plugins";
        String configType = this.launchConfig.getType().getIdentifier();
        if (configType.equals("org.eclipse.pde.ui.EquinoxLauncher") || configType.equals("org.eclipse.rap.ui.launch.RAPLauncher")) {
            workspaceId = "workspace_bundles";
            targetId = "target_bundles";
        }
        HashSet set = new HashSet();
        Map map = BundleLauncherHelper.getWorkspaceBundleMap((ILaunchConfiguration)this.launchConfig, set, (String)workspaceId);
        map.putAll(BundleLauncherHelper.getTargetBundleMap((ILaunchConfiguration)this.launchConfig, set, (String)targetId));
        this.addPlugins(factory, product, map);
        this.handleDefaultConfig(product, factory);
    }

    private void handleDefaultConfig(IProduct product, IProductModelFactory factory) throws CoreException {
        String configDefault = "useDefaultConfig";
        boolean useDefault = this.launchConfig.getAttribute(configDefault, true);
        if (useDefault) {
            super.initializeProduct(product);
        } else {
            this.handleTemplatePath(product, factory);
        }
    }

    private void handleTemplatePath(IProduct product, IProductModelFactory factory) throws CoreException {
        String templateLocation = "templateConfig";
        String path = this.launchConfig.getAttribute(templateLocation, "/");
        IWorkspace workspace = PDEPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IContainer container = root.getContainerForLocation((IPath)new Path(path));
        if (container != null) {
            IConfigurationFileInfo info = factory.createConfigFileInfo();
            info.setUse(null, "custom");
            info.setPath(null, container.getFullPath().toString());
            product.setConfigurationFileInfo(info);
        } else {
            super.initializeProduct(product);
        }
    }

    private void handleVMArguments(IProduct product, IProductModelFactory factory) throws CoreException {
        IArgumentsInfo arguments;
        String vmArgumentsName = IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS;
        String vmargs = this.launchConfig.getAttribute(vmArgumentsName, "");
        String programArgumentsName = IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS;
        String programArgs = this.launchConfig.getAttribute(programArgumentsName, "");
        if (!(vmargs.equals("") && programArgs.equals("") || (arguments = product.getLauncherArguments()) == null)) {
            arguments = factory.createLauncherArguments();
            if (!vmargs.equals("")) {
                arguments.setVMArguments(vmargs, 0);
            }
            if (!programArgs.equals("")) {
                arguments.setProgramArguments(programArgs, 0);
            }
            product.setLauncherArguments(arguments);
        }
    }
}

