/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.linuxtools.internal.gcov.parser.Block;
import org.eclipse.linuxtools.internal.gcov.parser.CoverageInfo;
import org.eclipse.linuxtools.internal.gcov.parser.GcnoFunction;
import org.eclipse.linuxtools.internal.gcov.parser.Line;

public class SourceFile
implements Serializable {
    private static final long serialVersionUID = -9182882194956475711L;
    private final String name;
    private final int index;
    private final ArrayList<Line> lines = new ArrayList();
    private final TreeSet<GcnoFunction> fnctns = new TreeSet();
    private int numLines = 1;
    private final CoverageInfo cvrge = new CoverageInfo();
    private long maxCount = -1L;

    public SourceFile(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public void accumulateLineCounts() {
        for (Line line : this.lines) {
            if (!line.exists()) continue;
            this.cvrge.incLinesInstrumented();
            if (line.getCount() == 0L) continue;
            this.cvrge.incLinesExecuted();
        }
    }

    public long getmaxLineCount() {
        if (this.maxCount < 0L) {
            for (Line line : this.lines) {
                if (line.getCount() <= this.maxCount) continue;
                this.maxCount = line.getCount();
            }
        }
        return this.maxCount;
    }

    public int getLinesExecuted() {
        return this.cvrge.getLinesExecuted();
    }

    public int getLinesInstrumented() {
        return this.cvrge.getLinesInstrumented();
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<Line> getLines() {
        return this.lines;
    }

    public SortedSet<GcnoFunction> getFnctns() {
        return this.fnctns;
    }

    public void addFnctn(GcnoFunction fnctn) {
        this.fnctns.add(fnctn);
    }

    public int getNumLines() {
        return this.numLines;
    }

    public void setNumLines(int numLines) {
        this.numLines = numLines;
    }

    public int getIndex() {
        return this.index;
    }

    public void initializeLines() {
        if (this.lines.isEmpty()) {
            int n = this.getNumLines();
            this.lines.ensureCapacity(n);
            int j = 0;
            while (j < n) {
                this.lines.add(new Line());
                ++j;
            }
        }
    }

    public void createLines(ArrayList<SourceFile> allSrcs) {
        this.initializeLines();
        SourceFile source = this;
        for (GcnoFunction fn : this.getFnctns()) {
            block1: for (Block b : fn.getFunctionBlocks()) {
                long[] blockLines = b.getEncoding();
                if (blockLines == null) continue;
                int i = 0;
                while (i < blockLines.length) {
                    long sourceIndex;
                    long lineno = blockLines[i];
                    if (lineno == 0L && i < blockLines.length - 2 && (sourceIndex = blockLines[i + 1]) != 0L) {
                        source = allSrcs.get((int)(sourceIndex - 1L));
                        source.initializeLines();
                        lineno = blockLines[i + 2];
                        i += 2;
                    }
                    if (lineno == 0L) continue block1;
                    Line line = source.getLines().get((int)lineno);
                    line.addBlock(b);
                    ++i;
                }
            }
        }
    }
}

