/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ExtractedMap;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.HashMapCollectionExtractor;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="hash_entries")
@Icon(value="/META-INF/icons/hash_map.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
@Subjects(value={"java.util.AbstractMap", "java.util.jar.Attributes", "java.util.Dictionary", "java.lang.ThreadLocal$ThreadLocalMap", "java.util.concurrent.ConcurrentHashMap$Segment", "java.util.concurrent.ConcurrentHashMap$CollectionView", "java.util.Collections$SynchronizedMap", "java.util.Collections$UnmodifiableMap", "java.util.Collections$CheckedMap", "java.util.ImmutableCollections$AbstractImmutableMap", "java.util.ResourceBundle", "java.awt.RenderingHints", "sun.awt.WeakIdentityHashMap", "javax.script.SimpleBindings", "javax.management.openmbean.TabularDataSupport", "com.ibm.jvm.util.HashMapRT", "com.sap.engine.lib.util.AbstractDataStructure"})
public class HashEntriesQuery
implements IQuery {
    private static final String NULL = "<null>";
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public String collection;
    @Argument(isMandatory=false)
    public String array_attribute;
    @Argument(isMandatory=false)
    public String key_attribute;
    @Argument(isMandatory=false)
    public String value_attribute;

    public Result execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "DTFJ-PHD");
        listener.subTask(Messages.HashEntriesQuery_Msg_Extracting);
        HashMapCollectionExtractor specificExtractor = this.collection != null ? new HashMapCollectionExtractor(null, this.array_attribute, this.key_attribute, this.value_attribute) : null;
        ArrayList<Entry> hashEntries = new ArrayList<Entry>();
        int counter = 0;
        IClass type = null;
        for (int[] objectIds : this.objects) {
            int objectId;
            HashMapIntObject resultMap = null;
            int[] sortedObjs = objectIds;
            int prev = Integer.MIN_VALUE;
            int[] nArray = objectIds;
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                objectId = nArray[n2];
                if (objectId < prev) {
                    sortedObjs = (int[])objectIds.clone();
                    Arrays.sort(sortedObjs);
                    resultMap = new HashMapIntObject();
                    break;
                }
                prev = objectId;
                ++n2;
            }
            nArray = sortedObjs;
            n = sortedObjs.length;
            n2 = 0;
            while (n2 < n) {
                ExtractedMap map;
                objectId = nArray[n2];
                if (listener.isCanceled()) break;
                IObject obj = this.snapshot.getObject(objectId);
                if (counter++ % 1000 == 0 && !obj.getClazz().equals(type)) {
                    type = obj.getClazz();
                    listener.subTask(String.valueOf(Messages.HashEntriesQuery_Msg_Extracting) + "\n" + type.getName());
                }
                if ((map = CollectionExtractionUtils.extractMap(obj, this.collection, specificExtractor)) != null) {
                    ArrayList<Entry> hashEntries1 = resultMap != null ? new ArrayList<Entry>() : hashEntries;
                    for (Map.Entry<IObject, IObject> me : map) {
                        Entry e;
                        int valueId;
                        int keyId;
                        try {
                            keyId = me.getKey() != null ? me.getKey().getObjectId() : -1;
                        }
                        catch (RuntimeException e1) {
                            keyId = -1;
                        }
                        try {
                            valueId = me.getValue() != null ? me.getValue().getObjectId() : -1;
                        }
                        catch (RuntimeException e1) {
                            valueId = -1;
                        }
                        if (me instanceof IObject) {
                            IObject meObject = (IObject)((Object)me);
                            e = new Entry(obj.getObjectId(), obj.getDisplayName(), keyId, valueId);
                        } else {
                            e = new Entry(objectId, obj.getDisplayName(), keyId, valueId);
                        }
                        hashEntries1.add(e);
                    }
                    if (resultMap != null) {
                        resultMap.put(objectId, hashEntries1);
                    }
                }
                ++n2;
            }
            if (resultMap != null) {
                nArray = objectIds;
                n = objectIds.length;
                n2 = 0;
                while (n2 < n) {
                    objectId = nArray[n2];
                    if (resultMap.containsKey(objectId)) {
                        hashEntries.addAll((Collection)resultMap.get(objectId));
                    }
                    ++n2;
                }
            }
            if (listener.isCanceled()) break;
        }
        listener.done();
        return new Result(this.snapshot, hashEntries);
    }

    static class Entry {
        int collectionId;
        int keyId;
        int valueId;
        String collectionName;
        String keyValue;
        String valueValue;

        public Entry(int collectionId, String collectionName, int keyId, int valueId) {
            this.collectionId = collectionId;
            this.collectionName = collectionName;
            this.keyId = keyId;
            this.valueId = valueId;
        }
    }

    public static class Result
    implements IResultTable {
        private ISnapshot snapshot;
        private List<Entry> entries;
        private Map<String, Entry> key2entry;

        private Result(ISnapshot snapshot, List<Entry> entries) {
            this.snapshot = snapshot;
            this.entries = entries;
        }

        public ResultMetaData getResultMetaData() {
            return new ResultMetaData.Builder().addContext(new ContextProvider(Messages.HashEntriesQuery_Column_Key){

                public IContextObject getContext(Object row) {
                    return this.getKey(row);
                }
            }).addContext(new ContextProvider(Messages.HashEntriesQuery_Column_Value){

                public IContextObject getContext(Object row) {
                    return this.getValue(row);
                }
            }).build();
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.HashEntriesQuery_Column_Collection).sorting(Column.SortDirection.ASC), new Column(Messages.HashEntriesQuery_Column_Key), new Column(Messages.HashEntriesQuery_Column_Value)};
        }

        public Object getColumnValue(Object row, int columnIndex) {
            Entry entry = (Entry)row;
            switch (columnIndex) {
                case 0: {
                    return entry.collectionName;
                }
                case 1: {
                    if (entry.keyValue == null) {
                        entry.keyValue = this.resolve(entry.keyId);
                    }
                    return entry.keyValue;
                }
                case 2: {
                    if (entry.valueValue == null) {
                        entry.valueValue = this.resolve(entry.valueId);
                    }
                    return entry.valueValue;
                }
            }
            return null;
        }

        private String resolve(int objectId) {
            block4: {
                try {
                    if (objectId >= 0) break block4;
                    return HashEntriesQuery.NULL;
                }
                catch (SnapshotException e) {
                    throw new RuntimeException(e);
                }
            }
            IObject object = this.snapshot.getObject(objectId);
            String name = object.getClassSpecificName();
            if (name == null) {
                name = object.getTechnicalName();
            }
            return name;
        }

        public int getRowCount() {
            return this.entries.size();
        }

        public Object getRow(int rowId) {
            return this.entries.get(rowId);
        }

        public IContextObject getContext(final Object row) {
            return new IContextObject(){

                public int getObjectId() {
                    return ((Entry)row).collectionId;
                }
            };
        }

        private IContextObject getKey(Object row) {
            final int keyId = ((Entry)row).keyId;
            if (keyId >= 0) {
                return new IContextObject(){

                    public int getObjectId() {
                        return keyId;
                    }
                };
            }
            return null;
        }

        private IContextObject getValue(Object row) {
            final int valueId = ((Entry)row).valueId;
            if (valueId >= 0) {
                return new IContextObject(){

                    public int getObjectId() {
                        return valueId;
                    }
                };
            }
            return null;
        }

        public synchronized String getString(String key, IProgressListener listener) {
            this.prepare(listener);
            Entry entry = this.key2entry.get(key);
            if (entry == null) {
                return null;
            }
            if (entry.valueValue == null) {
                entry.valueValue = this.resolve(entry.valueId);
            }
            return entry.valueValue == HashEntriesQuery.NULL ? null : entry.valueValue;
        }

        public synchronized int getObjectId(String key, IProgressListener listener) {
            this.prepare(listener);
            Entry entry = this.key2entry.get(key);
            if (entry == null) {
                return -1;
            }
            return entry.keyId;
        }

        private synchronized void prepare(IProgressListener listener) {
            if (this.key2entry != null) {
                return;
            }
            this.key2entry = new HashMap<String, Entry>();
            for (Entry entry : this.entries) {
                if (entry.keyValue == null) {
                    entry.keyValue = this.resolve(entry.keyId);
                }
                this.key2entry.put(entry.keyValue, entry);
                if (listener.isCanceled()) break;
            }
        }
    }
}

