/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.custom.editor.dialogs;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.modisco.infra.browser.custom.editor.Messages;
import org.eclipse.modisco.infra.browser.custom.editor.dialogs.EditFeatureValueDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconFeatureDialog
extends EditFeatureValueDialog {
    private final Shell fParentShell;
    private Text text;

    public IconFeatureDialog(Shell parentShell, boolean withCondition, boolean withDefault, List<String> availableQuerySets, List<Class<?>> expectedReturnTypes, EClass customizedMetaclass) {
        super(parentShell, withCondition, withDefault, availableQuerySets, expectedReturnTypes, customizedMetaclass);
        this.fParentShell = parentShell;
    }

    @Override
    protected void createValueEditor(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text = new Text(composite, 2048);
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.getInitialStaticValue() != null) {
            this.text.setText(this.getInitialStaticValue());
        }
        Button button = new Button(composite, 8);
        button.setText(Messages.CustomizationEditor_btnOpenElementSelectionDialogText);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile selectedFile = IconFeatureDialog.this.openIconSelectionDialog(IconFeatureDialog.this.getShell(), IconFeatureDialog.this.getText().getText());
                if (selectedFile != null) {
                    IconFeatureDialog.this.getText().setText(selectedFile.getFullPath().toString());
                }
            }
        });
    }

    protected IFile openIconSelectionDialog(Shell shell, String initialText) {
        int result;
        ElementTreeSelectionDialog iconSelectionDialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        iconSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        iconSelectionDialog.setAllowMultiple(false);
        iconSelectionDialog.setMessage(Messages.CustomizationEditor_selectAnIcon);
        iconSelectionDialog.setTitle(Messages.CustomizationEditor_iconSelection);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(initialText);
        if (resource != null) {
            iconSelectionDialog.setInitialSelection((Object)resource);
        }
        if ((result = iconSelectionDialog.open()) == 0) {
            Object firstResult = iconSelectionDialog.getFirstResult();
            if (firstResult instanceof IFile) {
                IFile file = (IFile)firstResult;
                return file;
            }
            MessageDialog.openWarning((Shell)this.fParentShell, (String)Messages.CustomizationEditor_invalidSelection, (String)Messages.CustomizationEditor_notFileSelected);
        }
        return null;
    }

    @Override
    protected void okPressed() {
        if (this.text != null) {
            this.setStaticValue(this.text.getText());
        }
        super.okPressed();
    }

    public Text getText() {
        return this.text;
    }
}

