/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.format.CaseDefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.autoEdit.IAppliedAutoEditStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class CaseDefaultAutoEditStrategy
extends CaseDefaultIndentationStrategy
implements IAppliedAutoEditStrategy {
    private StringBuilder buffer = new StringBuilder();
    private boolean applied = false;

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        this.applied = false;
        if (command.text == null) {
            return;
        }
        String checkWord = null;
        String addedWord = null;
        if (command.text.endsWith("t")) {
            checkWord = "defaul";
            addedWord = "default";
        } else if (command.text.endsWith("e")) {
            checkWord = "cas";
            addedWord = "case";
        } else {
            return;
        }
        IStructuredDocument sDocument = (IStructuredDocument)document;
        if (FormatterUtils.getPartitionType((IStructuredDocument)sDocument, (int)command.offset) != "org.eclipse.php.PHP_DEFAULT") {
            return;
        }
        int length = checkWord.length();
        if (command.offset < length + 1) {
            return;
        }
        try {
            if (document.get(command.offset - length, length).equals(checkWord)) {
                this.autoIdentCaseDefault(sDocument, command, addedWord);
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    @Override
    public boolean wasApplied() {
        return this.applied;
    }

    private void autoIdentCaseDefault(IStructuredDocument document, DocumentCommand command, String addedWord) throws BadLocationException {
        int startOffset = command.offset - addedWord.length() + 1;
        int lineNumber = document.getLineOfOffset(command.offset);
        IRegion lineInfo = document.getLineInformation(lineNumber);
        int lineOffset = lineInfo.getOffset();
        String lineStart = document.get(lineOffset, startOffset - lineOffset);
        if (StringUtils.isBlank((CharSequence)lineStart)) {
            this.buffer.setLength(0);
            this.placeMatchingBlanks(document, this.buffer, lineNumber, startOffset);
            String bufferString = this.buffer.toString();
            if (!bufferString.equals(lineStart)) {
                command.length += command.offset - lineOffset;
                command.offset = lineOffset;
                command.text = String.valueOf(bufferString) + addedWord;
            }
            this.applied = true;
        }
    }
}

