/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTcUtil;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTrNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.AbstractRelation2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.Invocation2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.Relation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.VariableDeclaration2TraceProperty;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.SharedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.TemplateVariable;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

abstract class AbstractRelation2TraceClass
extends AbstractRelation2MiddleType
implements Relation2TraceClass {
    private @Nullable Map<@NonNull RelationCallExp, @NonNull Invocation2TraceProperty> invocation2relation2traceProperty = null;
    private final @NonNull Map<@NonNull String, @Nullable Element2MiddleProperty> name2element2traceProperty = new HashMap<String, Element2MiddleProperty>();

    protected AbstractRelation2TraceClass(@NonNull RelationAnalysis relationAnalysis, @NonNull String middleClassName) {
        super(relationAnalysis, middleClassName);
    }

    @Override
    public void analyze() throws CompilerChainException {
        boolean manyTraces = this.analyzeTraceMultiplicity();
        this.analyzeSharedVariables();
        this.analyzeRootTemplateVariables(manyTraces);
        this.analyzeNonRootTemplateVariables(manyTraces);
        this.analyzeInvocationVariables();
    }

    protected void analyzeInvocationVariable(@NonNull RelationCallExp rInvocation) {
        Relation invokedRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)rInvocation);
        if (!invokedRelation.isIsTopLevel()) {
            this.getInvocation2TraceProperty(rInvocation);
        }
    }

    protected void analyzeInvocationVariables() {
        Iterable<RelationCallExp> outgoingWhereInvocations;
        Iterable<@NonNull RelationCallExp> outgoingInvocations = this.relationAnalysis.getOutgoingInvocations();
        if (outgoingInvocations != null) {
            for (RelationCallExp rInvocation : outgoingInvocations) {
                this.analyzeInvocationVariable(rInvocation);
            }
        }
        if ((outgoingWhereInvocations = this.relationAnalysis.getOutgoingWhereInvocations()) != null) {
            for (RelationCallExp rInvocation : outgoingWhereInvocations) {
                Relation invokedRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)rInvocation);
                if (invokedRelation.isIsTopLevel()) continue;
                this.getInvocation2TraceProperty(rInvocation).getTraceProperty();
            }
        }
    }

    protected boolean analyzeTraceMultiplicity() {
        boolean manyTraces;
        boolean bl = manyTraces = this.hasManyRootMatches() || this.hasCollectionMemberMatches() || this.hasMultiObjectMatches();
        if (!manyTraces) {
            for (Variable rVariable : QVTrelationUtil.getOwnedVariables((Relation)this.relation)) {
                if (!this.hasManyVariableMatches(rVariable)) continue;
                manyTraces = true;
                break;
            }
        }
        return manyTraces;
    }

    protected void analyzeNonRootTemplateVariables(boolean manyTraces) {
        for (RelationDomain rDomain : QVTrelationUtil.getOwnedDomains((Relation)this.relation)) {
            for (DomainPattern rDomainPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)rDomain)) {
                TemplateExp rTemplateExp = QVTrelationUtil.getOwnedTemplateExpression((DomainPattern)rDomainPattern);
                TypedModel rTypedModel = QVTrelationUtil.getTypedModel((Domain)rDomain);
                this.analyzeTemplateVariables(rTemplateExp, rTypedModel, !manyTraces);
            }
        }
    }

    protected void analyzeSharedVariables() {
        for (Variable rVariable : QVTrelationUtil.getOwnedVariables((Relation)this.relation)) {
            if (rVariable instanceof IteratorVariable || rVariable instanceof TemplateVariable || rVariable.isIsImplicit()) continue;
            assert (rVariable instanceof SharedVariable);
            this.getVariableDeclaration2TraceProperty(null, (VariableDeclaration)rVariable, false);
        }
    }

    private void analyzeTemplateVariables(@NonNull TemplateExp templateExp, @NonNull TypedModel rTypedModel, boolean isOneToOne) {
        block8: {
            block9: {
                Variable templateVariable = QVTrelationUtil.getBindsTo((TemplateExp)templateExp);
                VariableDeclaration2TraceProperty variableDeclaration2TraceProperty = this.basicGetVariableDeclaration2TraceProperty((VariableDeclaration)templateVariable);
                if (variableDeclaration2TraceProperty == null) break block8;
                if (!(templateExp instanceof ObjectTemplateExp)) break block9;
                for (PropertyTemplateItem rPropertyTemplateItem : QVTrelationUtil.getOwnedParts((ObjectTemplateExp)((ObjectTemplateExp)templateExp))) {
                    Variable itemVariable;
                    OCLExpression valueExpression;
                    Property oppositeProperty;
                    boolean isNestedOneToOne = false;
                    Property property = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)rPropertyTemplateItem);
                    if (!property.isIsMany() && (oppositeProperty = property.getOpposite()) != null && !oppositeProperty.isIsMany()) {
                        isNestedOneToOne = isOneToOne;
                    }
                    if ((valueExpression = QVTrelationUtil.getOwnedValue((PropertyTemplateItem)rPropertyTemplateItem)) instanceof TemplateExp) {
                        TemplateExp templateValueExpression = (TemplateExp)valueExpression;
                        itemVariable = QVTrelationUtil.getBindsTo((TemplateExp)templateValueExpression);
                        if (QVTrelationUtil.getElementalType((Type)QVTrelationUtil.getType((TypedElement)itemVariable)) instanceof DataType) {
                            this.getVariableDeclaration2TraceProperty(null, (VariableDeclaration)itemVariable, false);
                            continue;
                        }
                        assert (itemVariable instanceof TemplateVariable);
                        this.getVariableDeclaration2TraceProperty(rTypedModel, (VariableDeclaration)itemVariable, isNestedOneToOne);
                        this.analyzeTemplateVariables(templateValueExpression, rTypedModel, isOneToOne);
                        continue;
                    }
                    if (!(valueExpression instanceof VariableExp)) continue;
                    VariableExp variableExpression = (VariableExp)valueExpression;
                    itemVariable = QVTrelationUtil.getReferredVariable((VariableExp)variableExpression);
                    this.getVariableDeclaration2TraceProperty(null, (VariableDeclaration)itemVariable, isNestedOneToOne);
                }
                break block8;
            }
            if (!(templateExp instanceof CollectionTemplateExp)) break block8;
            for (OCLExpression memberExpression : QVTrelationUtil.getOwnedMembers((CollectionTemplateExp)((CollectionTemplateExp)templateExp))) {
                Variable itemVariable;
                if (memberExpression instanceof TemplateExp) {
                    TemplateExp templateValueExpression = (TemplateExp)memberExpression;
                    itemVariable = QVTrelationUtil.getBindsTo((TemplateExp)templateValueExpression);
                    assert (itemVariable instanceof TemplateVariable);
                    this.getVariableDeclaration2TraceProperty(rTypedModel, (VariableDeclaration)itemVariable, false);
                    this.analyzeTemplateVariables(templateValueExpression, rTypedModel, false);
                    continue;
                }
                if (!(memberExpression instanceof VariableExp)) continue;
                VariableExp variableExpression = (VariableExp)memberExpression;
                itemVariable = QVTrelationUtil.getReferredVariable((VariableExp)variableExpression);
                this.getVariableDeclaration2TraceProperty(null, (VariableDeclaration)itemVariable, false);
            }
        }
    }

    public @NonNull String createInvocationClassName() {
        return this.relationAnalysis.getNameGenerator().createInvocationClassName(this.relation);
    }

    public @NonNull String createInvocationInterfaceName() {
        return this.relationAnalysis.getNameGenerator().createInvocationInterfaceName(this.relation);
    }

    public @NonNull Property createProperty(@NonNull String name, @NonNull Type type) {
        String uniqueName = QVTrNameGenerator.getUniqueName(this.name2element2traceProperty.keySet(), name);
        Property property = PivotUtil.createProperty((String)uniqueName, (Type)type);
        return property;
    }

    public @NonNull String createTraceInterfaceName() {
        return this.relationAnalysis.getNameGenerator().createTraceInterfaceName(this.relation);
    }

    @Override
    public @NonNull Invocation2TraceProperty getInvocation2TraceProperty(@NonNull RelationCallExp rInvocation) {
        Invocation2TraceProperty relation2traceProperty;
        Map<@NonNull RelationCallExp, @NonNull Invocation2TraceProperty> invocation2relation2traceProperty2 = this.invocation2relation2traceProperty;
        if (invocation2relation2traceProperty2 == null) {
            this.invocation2relation2traceProperty = invocation2relation2traceProperty2 = new HashMap<RelationCallExp, Invocation2TraceProperty>();
        }
        if ((relation2traceProperty = invocation2relation2traceProperty2.get(rInvocation)) == null) {
            Relation invokedRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)rInvocation);
            Relation2TraceClass invokedRelation2TraceClass = this.relationalTransformation2tracePackage.getRelation2TraceClass(invokedRelation);
            relation2traceProperty = new Invocation2TraceProperty(this, invokedRelation2TraceClass.getRelation2InvocationClass());
            invocation2relation2traceProperty2.put(rInvocation, relation2traceProperty);
        }
        return relation2traceProperty;
    }

    @Override
    public @NonNull AbstractRelation2TraceClass getRelation2TraceClass() {
        return this;
    }

    @Override
    public @NonNull String getUniquePropertyName(@NonNull Element2MiddleProperty element2traceProperty, @NonNull String name) {
        return QVTrNameGenerator.getUniqueName(this.name2element2traceProperty, name, element2traceProperty);
    }

    private boolean hasCollectionMemberMatches() {
        for (EObject eObject : new TreeIterable((EObject)this.relation, true)) {
            EList members;
            if (!(eObject instanceof CollectionTemplateExp) || (members = ((CollectionTemplateExp)eObject).getMember()).size() <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean hasManyRootMatches() {
        @NonNull List rDomains = QVTrelationUtil.Internal.getOwnedDomainsList((Relation)this.relation);
        if (rDomains.size() > 2) {
            return true;
        }
        for (Domain rDomain : rDomains) {
            EList rootVariables = ((RelationDomain)rDomain).getRootVariable();
            if (rootVariables.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean hasManyVariableMatches(@NonNull Variable rVariable) {
        for (Domain rDomain : QVTrelationUtil.getOwnedDomains((Relation)this.relation)) {
            Iterable<@NonNull Variable> bindsTo = QVTr2QVTcUtil.getRelationDomainBindsTo((RelationDomain)rDomain);
            if (!Iterables.contains(bindsTo, (Object)rVariable)) continue;
            return false;
        }
        for (EObject eObject : new TreeIterable((EObject)this.relation, true)) {
            EObject eContainer;
            VariableDeclaration referredVariable;
            if (!(eObject instanceof VariableExp) || (referredVariable = ((VariableExp)eObject).getReferredVariable()) != rVariable || !((eContainer = eObject.eContainer()) instanceof OperationCallExp)) continue;
            OperationCallExp operationCallExp = (OperationCallExp)eContainer;
            Operation referredOperation = operationCallExp.getReferredOperation();
            assert (referredOperation != null);
            if (!operationCallExp.getOwnedArguments().equals(Collections.singletonList(eObject)) || !"includes".equals(referredOperation.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasMultiObjectMatches() {
        for (RelationDomain relationDomain : QVTrelationUtil.getOwnedDomains((Relation)this.relation)) {
            if (!relationDomain.isNotOutput()) continue;
            for (EObject eObject : new TreeIterable((EObject)relationDomain, true)) {
                Property referredProperty;
                if (!(eObject instanceof PropertyTemplateItem) || !(referredProperty = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)((PropertyTemplateItem)eObject))).isIsMany()) continue;
                return true;
            }
        }
        return false;
    }

    protected void reservePropertyName(@NonNull String name) {
        assert (!this.name2element2traceProperty.containsKey(name));
        this.name2element2traceProperty.put(name, null);
    }

    @Override
    public void synthesize() {
        Map<@NonNull RelationCallExp, @NonNull Invocation2TraceProperty> invocation2relation2traceProperty2 = this.invocation2relation2traceProperty;
        if (invocation2relation2traceProperty2 != null) {
            for (Invocation2TraceProperty relation2traceProperty : invocation2relation2traceProperty2.values()) {
                relation2traceProperty.synthesize();
            }
        }
        super.synthesize();
    }
}

