/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.layers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.componentization.mappings.table.CandidateMapping;
import org.eclipse.sirius.diagram.business.internal.layers.MappingTableEntry;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.AbstractMappingImport;

public class MappingsTable<T extends DiagramElementMapping> {
    private final List<MappingTableEntry> mappingsTable = new ArrayList<MappingTableEntry>();

    public void clear() {
        this.mappingsTable.clear();
    }

    public void build(Collection<CandidateMapping> candidateMappings) {
        this.addNotImportMappings(candidateMappings);
        this.addImportMappings(candidateMappings);
    }

    private void addNotImportMappings(Collection<CandidateMapping> candidateMappings) {
        for (CandidateMapping candidate : candidateMappings) {
            DiagramElementMapping mapping = candidate.getMapping();
            if (mapping instanceof NodeMappingImport || mapping instanceof ContainerMappingImport || mapping instanceof EdgeMappingImport) continue;
            this.addNotImportMappingInTable(candidate);
        }
    }

    private void addImportMappings(Collection<CandidateMapping> candidateMappings) {
        for (CandidateMapping candidate : candidateMappings) {
            DiagramElementMapping mapping = candidate.getMapping();
            if (!(mapping instanceof AbstractMappingImport) && !(mapping instanceof EdgeMappingImport)) continue;
            this.addImportMappingInTable(candidate, candidateMappings);
        }
    }

    public List<T> availableSortedMappingsList(List<T> originalMappings) {
        ArrayList<DiagramElementMapping> result = new ArrayList<DiagramElementMapping>();
        for (DiagramElementMapping mapping : originalMappings) {
            List<DiagramElementMapping> sortedMappings = this.availableSortedMappingsList(mapping);
            for (DiagramElementMapping sortedMapping : sortedMappings) {
                if (result.contains(sortedMapping)) continue;
                result.add(sortedMapping);
            }
        }
        return result;
    }

    private List<T> availableSortedMappingsList(T mapping) {
        MappingTableEntry entry = this.searchEntry((DiagramElementMapping)mapping);
        if (entry == null) {
            return Collections.emptyList();
        }
        List<T> list = this.convertMappingNodeToList(entry);
        return list;
    }

    public List<T> otherImportersMappingsList() {
        ArrayList<T> result = new ArrayList<T>();
        Iterator<MappingTableEntry> it = this.getSafeIterator();
        while (it.hasNext()) {
            MappingTableEntry mNode = it.next();
            List<T> list = this.convertMappingNodeToImportersList(mNode);
            result.addAll(list);
        }
        return result;
    }

    private Iterator<MappingTableEntry> getSafeIterator() {
        return new ArrayList<MappingTableEntry>(this.mappingsTable).iterator();
    }

    public MappingTableEntry searchMappingEntry(T searchedMapping) {
        return this.searchEntry((DiagramElementMapping)searchedMapping);
    }

    private List<T> convertMappingNodeToList(MappingTableEntry mNode) {
        LinkedList<DiagramElementMapping> list = new LinkedList<DiagramElementMapping>();
        MappingTableEntry current = mNode;
        list.add(current.getMapping());
        for (MappingTableEntry mappingTableEntry : current.getImporters()) {
            list.add(0, mappingTableEntry.getMapping());
            this.convertMappingNodeToList(list, mappingTableEntry);
        }
        return list;
    }

    private void convertMappingNodeToList(List<T> list, MappingTableEntry current) {
        for (MappingTableEntry mappingTableEntry : current.getImporters()) {
            list.add(0, mappingTableEntry.getMapping());
            this.convertMappingNodeToList(list, mappingTableEntry);
        }
    }

    private List<T> convertMappingNodeToImportersList(MappingTableEntry mNode) {
        LinkedList<DiagramElementMapping> list = new LinkedList<DiagramElementMapping>();
        MappingTableEntry current = mNode;
        Collection<MappingTableEntry> others = current.getOtherImporters();
        for (MappingTableEntry mappingNode : others) {
            list.add(0, mappingNode.getMapping());
        }
        while (current.getImporter().some()) {
            current = (MappingTableEntry)current.getImporter().get();
            others = current.getOtherImporters();
            for (MappingTableEntry mappingNode : others) {
                list.add(0, mappingNode.getMapping());
            }
        }
        return list;
    }

    private MappingTableEntry searchEntry(DiagramElementMapping searchedMapping) {
        Iterator<MappingTableEntry> itListEntry = this.getSafeIterator();
        MappingTableEntry node = null;
        while (itListEntry.hasNext() && node == null) {
            MappingTableEntry currentTreeEntry = itListEntry.next();
            node = currentTreeEntry.searchMappingEntry(searchedMapping);
        }
        return node;
    }

    private void addNotImportMappingInTable(CandidateMapping candidate) {
        MappingTableEntry entry = new MappingTableEntry(candidate.getMapping(), candidate.getParentLayer(), candidate.getParentLayers());
        DiagramElementMapping mapping = entry.getMapping();
        MappingTableEntry existingEntry = this.searchEntry(mapping);
        if (existingEntry == null) {
            this.mappingsTable.add(entry);
        }
    }

    private Option<CandidateMapping> getImportedCandidateMapping(Collection<CandidateMapping> candidateMappings, DiagramElementMapping importedMapping) {
        for (CandidateMapping candidateMapping : candidateMappings) {
            if (!candidateMapping.getMapping().equals(importedMapping)) continue;
            return Options.newSome((Object)candidateMapping);
        }
        return Options.newNone();
    }

    private void addImportMappingInTable(CandidateMapping candidate, Collection<CandidateMapping> candidateMappings) {
        MappingTableEntry entry = new MappingTableEntry(candidate.getMapping(), candidate.getParentLayer(), candidate.getParentLayers());
        DiagramElementMapping mapping = entry.getMapping();
        DiagramElementMapping importedMapping = this.getImportedMapping(mapping);
        MappingTableEntry importedMappingExistingEntry = this.searchEntry(importedMapping);
        MappingTableEntry mappingEntry = this.searchEntry(entry.getMapping());
        if (mappingEntry != null) {
            entry = mappingEntry;
        }
        if (importedMappingExistingEntry == null) {
            this.mappingsTable.add(entry);
            Option<CandidateMapping> importedCandidate = this.getImportedCandidateMapping(candidateMappings, importedMapping);
            if (importedCandidate.some()) {
                importedMappingExistingEntry = new MappingTableEntry(((CandidateMapping)importedCandidate.get()).getMapping(), ((CandidateMapping)importedCandidate.get()).getParentLayer(), ((CandidateMapping)importedCandidate.get()).getParentLayers());
                this.mappingsTable.add(importedMappingExistingEntry);
            }
        }
        if (importedMappingExistingEntry != null) {
            Option<MappingTableEntry> previousImporter = importedMappingExistingEntry.getImporter();
            if (previousImporter.some()) {
                importedMappingExistingEntry.addOtherImporters((MappingTableEntry)previousImporter.get());
            }
            importedMappingExistingEntry.setImporter(entry);
        }
    }

    private DiagramElementMapping getImportedMapping(DiagramElementMapping mapping) {
        DiagramElementMapping importedMapping = null;
        if (mapping instanceof NodeMappingImport) {
            importedMapping = ((NodeMappingImport)mapping).getImportedMapping();
        } else if (mapping instanceof ContainerMappingImport) {
            importedMapping = ((ContainerMappingImport)mapping).getImportedMapping();
        } else if (mapping instanceof EdgeMappingImport) {
            IEdgeMappingQuery query = new IEdgeMappingQuery(((EdgeMappingImport)((Object)mapping)).getImportedMapping());
            importedMapping = (DiagramElementMapping)query.getEdgeMapping().get();
        }
        return importedMapping;
    }
}

