/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.extender.MetamodelDescriptorManager;
import org.eclipse.sirius.business.api.helper.SiriusResourceHelper;
import org.eclipse.sirius.business.api.query.DAnalysisQuery;
import org.eclipse.sirius.business.internal.metamodel.helper.ComponentizationHelper;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

final class DViewOperations {
    private final DAnalysisSessionImpl session;

    private DViewOperations(DAnalysisSessionImpl session) {
        this.session = session;
    }

    public static DViewOperations on(DAnalysisSessionImpl session) {
        return new DViewOperations((DAnalysisSessionImpl)Preconditions.checkNotNull((Object)session));
    }

    public Collection<Viewpoint> getSelectedViewpoints(boolean includeReferencedAnalysis) {
        TreeSet<Viewpoint> result = new TreeSet<Viewpoint>(new ViewpointRegistry.ViewpointComparator());
        Collection<DAnalysis> scope = includeReferencedAnalysis ? this.session.allAnalyses() : Collections.singleton(this.session.getMainAnalysis());
        for (DView view : this.getSelectedViews(scope)) {
            Viewpoint viewpoint = view.getViewpoint();
            if (viewpoint == null || viewpoint.eIsProxy()) continue;
            result.add(viewpoint);
        }
        return Collections.unmodifiableSet(result);
    }

    public Collection<DView> getSelectedViews(Iterable<DAnalysis> analyses) {
        LinkedHashSet<DView> selectedViews = new LinkedHashSet<DView>();
        for (DAnalysis analysis : analyses) {
            if (analysis == null) continue;
            selectedViews.addAll((Collection<DView>)analysis.getSelectedViews());
        }
        return selectedViews;
    }

    public Collection<Viewpoint> getSelectedViewpointsSpecificToGeneric() {
        Collection<Viewpoint> viewpoints = this.getSelectedViewpoints(false);
        ArrayList<Viewpoint> orderedViewpoints = new ArrayList<Viewpoint>(viewpoints.size());
        for (Viewpoint viewpoint : viewpoints) {
            int insertPosition = orderedViewpoints.size();
            for (Viewpoint viewpoint2 : orderedViewpoints) {
                if (ComponentizationHelper.isExtendedBy(viewpoint, viewpoint2)) {
                    insertPosition = orderedViewpoints.indexOf(viewpoint2);
                    continue;
                }
                if (!ComponentizationHelper.isExtendedBy(viewpoint2, viewpoint)) continue;
                insertPosition = orderedViewpoints.indexOf(viewpoint2) + 1;
            }
            orderedViewpoints.add(insertPosition, viewpoint);
        }
        return Collections.unmodifiableCollection(orderedViewpoints);
    }

    public void createView(Viewpoint viewpoint, Collection<EObject> semantics, boolean createNewRepresentations, IProgressMonitor monitor) {
        try {
            monitor.beginTask(MessageFormat.format(Messages.DViewOperations_createViewMsg, viewpoint.getName()), 3 + 10 * semantics.size());
            LinkedHashSet<DView> intializedDViews = new LinkedHashSet<DView>();
            for (DAnalysis analysis : this.session.allAnalyses()) {
                if (this.hasAlreadyDViewForViewpoint(analysis, viewpoint)) continue;
                DView view = this.getOrCreateFreshDView(analysis);
                view.setViewpoint(viewpoint);
                analysis.getOwnedViews().add((Object)view);
                analysis.getSelectedViews().add((Object)view);
                intializedDViews.add(view);
            }
            monitor.worked(1);
            this.session.configureInterpreter();
            if (createNewRepresentations) {
                monitor.subTask(Messages.DViewOperations_initRepresentationMsg);
                for (EObject semantic : semantics) {
                    DialectManager.INSTANCE.initRepresentations(viewpoint, semantic, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                }
            }
            this.updateSelectedViewpointsData((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.worked(1);
            if (!intializedDViews.isEmpty()) {
                this.session.notifyListeners(0);
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    public void addSelectedView(DView view, IProgressMonitor monitor) throws IllegalArgumentException {
        try {
            monitor.beginTask(Messages.DViewOperations_addSelectedViewMsg, 3);
            DAnalysis foundAnalysis = null;
            for (DAnalysis dAnalysis : this.session.allAnalyses()) {
                if (!dAnalysis.getOwnedViews().contains((Object)view)) continue;
                foundAnalysis = dAnalysis;
                break;
            }
            if (foundAnalysis == null) {
                throw new IllegalArgumentException(Messages.DViewOperations_notContainedErrorMsg);
            }
            foundAnalysis.getSelectedViews().add((Object)view);
            monitor.worked(1);
            this.updateSelectedViewpointsData((IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
            this.session.notifyListeners(0);
            monitor.worked(1);
            this.session.configureInterpreter();
        }
        finally {
            monitor.done();
        }
    }

    public void removeSelectedView(DView view, IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.DViewOperations_removeSelectedViewMsg, 1);
            this.session.getMainAnalysis().getSelectedViews().remove((Object)view);
            this.updateSelectedViewpointsData((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.session.notifyListeners(0);
            this.session.configureInterpreter();
        }
        finally {
            monitor.done();
        }
    }

    public Collection<DView> getOwnedViews() {
        LinkedHashSet<DView> ownedViews = new LinkedHashSet<DView>();
        for (DAnalysis analysis : this.session.allAnalyses()) {
            ownedViews.addAll((Collection<DView>)analysis.getOwnedViews());
        }
        return ownedViews;
    }

    public void updateSelectedViewpointsData(IProgressMonitor monitor) {
        try {
            Resource viewpointResource;
            LinkedHashSet<Viewpoint> selectedViewpoints = new LinkedHashSet<Viewpoint>();
            for (Viewpoint viewpoint : this.getSelectedViewpoints(false)) {
                if (viewpoint.eResource() != null) {
                    selectedViewpoints.add(SiriusResourceHelper.getCorrespondingViewpoint(this.session, viewpoint));
                    continue;
                }
                selectedViewpoints.add(viewpoint);
            }
            Sets.SetView difference = Sets.difference((Set)Sets.newHashSet(this.session.getActivatedViewpoints()), (Set)Sets.newHashSet(selectedViewpoints));
            monitor.beginTask(Messages.DViewOperations_updateSelectedVPDataMsg, selectedViewpoints.size() + difference.size() + 1);
            for (Viewpoint viewpoint : selectedViewpoints) {
                viewpointResource = viewpoint.eResource();
                if (viewpointResource != null) {
                    this.session.registerResourceInCrossReferencer(viewpointResource);
                }
                monitor.worked(1);
            }
            for (Viewpoint viewpoint : difference) {
                viewpointResource = viewpoint.eResource();
                if (viewpointResource != null) {
                    this.session.unregisterResourceInCrossReferencer(viewpointResource);
                }
                monitor.worked(1);
            }
            this.session.getActivatedViewpoints().addAll(selectedViewpoints);
            this.session.getActivatedViewpoints().retainAll(selectedViewpoints);
            ModelAccessor accessor = this.session.getModelAccessor();
            Collection<MetamodelDescriptor> metamodels = MetamodelDescriptorManager.INSTANCE.provides(this.getSelectedViewpoints(false));
            if (accessor != null) {
                accessor.activateMetamodels(metamodels);
            }
            this.session.getInterpreter().activateMetamodels(metamodels);
        }
        finally {
            monitor.done();
        }
    }

    private DView getOrCreateFreshDView(DAnalysis analysis) {
        DView orphan = new DAnalysisQuery(analysis).getFirstOrphanDView();
        if (orphan != null) {
            return orphan;
        }
        return ViewpointFactory.eINSTANCE.createDView();
    }

    private boolean hasAlreadyDViewForViewpoint(DAnalysis dAnalysis, Viewpoint viewpoint) {
        for (DView ownedDView : dAnalysis.getOwnedViews()) {
            Viewpoint vp = ownedDView.getViewpoint();
            if (vp == null || !EqualityHelper.areEquals((EObject)vp, (EObject)viewpoint)) continue;
            return true;
        }
        return false;
    }
}

