/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.internal.support.MappingsSupport;

public class SeriesMapper {
    private static final Map<String, ISeriesSettings> DEFAULTS = new HashMap<String, ISeriesSettings>();
    private static final Map<String, ISeriesSettings> MAPPINGS = new HashMap<String, ISeriesSettings>();

    private SeriesMapper() {
    }

    public static void clearAll() {
        DEFAULTS.clear();
        MAPPINGS.clear();
    }

    public static void clear() {
        MAPPINGS.clear();
    }

    public static void remove(String key) {
        MAPPINGS.remove(key);
    }

    public static void putDefault(String key, ISeriesSettings seriesSettings) {
        if (key != null && seriesSettings != null) {
            DEFAULTS.put(key, seriesSettings);
        }
    }

    public static void put(String key, ISeriesSettings seriesSettings) {
        if (key != null && seriesSettings != null) {
            MAPPINGS.put(key, seriesSettings);
        }
    }

    public static void reset(String id) {
        SeriesMapper.remove(id);
        ISeriesSettings seriesSettingsDefault = SeriesMapper.getSeriesSettingsDefault(id);
        if (seriesSettingsDefault != null) {
            SeriesMapper.put(id, MappingsSupport.copySeriesSettings(seriesSettingsDefault));
        }
    }

    public static void reset() {
        SeriesMapper.clear();
        for (Map.Entry<String, ISeriesSettings> mapping : DEFAULTS.entrySet()) {
            ISeriesSettings seriesSettingsSource = mapping.getValue();
            SeriesMapper.put(mapping.getKey(), MappingsSupport.copySeriesSettings(seriesSettingsSource));
        }
    }

    public static Set<Map.Entry<String, ISeriesSettings>> getMappings() {
        return Collections.unmodifiableSet(MAPPINGS.entrySet());
    }

    public static boolean containsDefaultSeriesSetting(String id) {
        return DEFAULTS.containsKey(id);
    }

    public static ISeriesSettings getSeriesSettingsDefault(String id) {
        return DEFAULTS.get(id);
    }

    public static boolean containsMappedSeriesSetting(String id) {
        return MAPPINGS.containsKey(id);
    }

    public static ISeriesSettings getSeriesSettingsMapped(String id) {
        return MAPPINGS.get(id);
    }

    public static void mapSetting(String id, ISeriesSettings seriesSettings, ISeriesSettings seriesSettingsDefault) {
        if (seriesSettings != null) {
            SeriesMapper.put(id, seriesSettings);
            if (!SeriesMapper.containsDefaultSeriesSetting(id) && seriesSettingsDefault != null) {
                SeriesMapper.putDefault(id, seriesSettingsDefault);
            }
        }
    }

    public static ISeriesSettings getSeriesSettingsDefault(String id, ScrollableChart scrollableChart) {
        BaseChart baseChart;
        ISeriesSettings seriesSettings;
        ISeriesSettings seriesSettingsDefault = null;
        if (SeriesMapper.containsDefaultSeriesSetting(id)) {
            seriesSettingsDefault = SeriesMapper.getSeriesSettingsDefault(id);
        } else if (scrollableChart != null && (seriesSettings = (baseChart = scrollableChart.getBaseChart()).getSeriesSettings(id)) != null) {
            seriesSettingsDefault = MappingsSupport.copySeriesSettings(seriesSettings);
        }
        return seriesSettingsDefault;
    }
}

