/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.menu.legend;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.internal.support.MappingsSupport;
import org.eclipse.swtchart.extensions.menu.legend.AbstractMenuListener;

public class ShowSeriesAction
extends AbstractMenuListener {
    public ShowSeriesAction(SeriesListUI seriesListUI) {
        super(seriesListUI);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)new Action(){

            public String getText() {
                return "Show Series";
            }

            public String getToolTipText() {
                return "Show the selected series.";
            }

            public void run() {
                List<ISeries<?>> selectedSeries = ShowSeriesAction.this.getSelectedSeries();
                for (ISeries<?> series : selectedSeries) {
                    MappingsSupport.mapSettings(series, "Visible", true, ShowSeriesAction.this.getScrollableChart());
                }
                ShowSeriesAction.this.refresh();
            }
        });
    }
}

