/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.processes;

import org.eclipse.core.runtime.Assert;

public class ProcessKiller
implements Runnable {
    final Process process;
    final long timeout;
    private boolean finished;
    boolean killed;

    public ProcessKiller(Process process, long timeout) {
        Assert.isNotNull((Object)process);
        this.process = process;
        this.timeout = timeout;
        this.killed = false;
        this.finished = false;
    }

    @Override
    public void run() {
        try {
            if (this.timeout >= 0L) {
                Thread.sleep(this.timeout);
            }
            try {
                this.process.exitValue();
                this.setFinished(true);
            }
            catch (IllegalThreadStateException dummy) {
                this.process.destroy();
                this.setKilled(true);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected synchronized void setKilled(boolean killed) {
        this.killed = killed;
    }

    public synchronized boolean isKilled() {
        return this.killed;
    }

    protected synchronized void setFinished(boolean finished) {
        this.finished = finished;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }
}

