/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.js.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.chromium.debug.core.util.PlatformUtil;
import org.eclipse.wst.jsdt.chromium.debug.js.util.WindowsRegistryUtil;

public final class ChromiumDetector {
    private static final String EMPTY = "";
    private static final String WHERE_COMMAND = "where";
    private static final String WHICH_LOCATION_1 = "/usr/bin/which";
    public static final String WHICH_LOCATION_2 = "/bin/which";
    public static final String WHICH_LOCATION_3 = "/usr/local/bin/which";
    public static final String SYSTEM_PATH_ENV_VAR = "PATH";
    public static final String CHROMIUM_EXTRA_LOCATION = "/usr/local/bin";
    private static final String CHROMIUM_BROWSER = "chromium-browser";
    private static final String CHROME_WINDOWS = "chrome.exe";
    private static final String CHROME_LINUX = "google-chrome";
    private static final String CHROME_WINDOWS_REG_HKCU_LOCATION = "HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\\chrome.exe";
    private static final String CHROME_WINDOWS_REG_HKLM_LOCATION = "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\\chrome.exe";
    private static final String CHROME_WINDOWS_REG_KEY_NAME = "Path";
    private static final String MAC_CHROME_PATH = "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome";
    private static final String MAC_CHROMIUM_PATH = "/Applications/Chromium.app/Contents/MacOS/Chromium";
    private static final String MAC_CANARY_PATH = "/Applications/Google Chrome Canary.app/Contents/MacOS/Google Chrome Canary";

    private ChromiumDetector() {
    }

    public static File findChromiumSystemPath() {
        File chromiumFile = null;
        String output = null;
        output = PlatformUtil.isMacOS() ? ChromiumDetector.detectChromiumOnMacOs() : ChromiumDetector.locateSystemCommandPath(CHROMIUM_BROWSER);
        if (output.equals(EMPTY)) {
            output = ChromiumDetector.locateSystemCommandPath(CHROME_LINUX);
        }
        if (output.equals(EMPTY)) {
            String chromeFileName = PlatformUtil.isWindows() ? CHROME_WINDOWS : CHROMIUM_BROWSER;
            String path = System.getenv(SYSTEM_PATH_ENV_VAR);
            String[] paths = path.split(File.pathSeparator, 0);
            ArrayList<String> directories = new ArrayList<String>();
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                directories.add(p);
                ++n2;
            }
            if (!PlatformUtil.isWindows()) {
                directories.add(CHROMIUM_EXTRA_LOCATION);
            }
            boolean notFound = true;
            Iterator it = directories.iterator();
            while (notFound && it.hasNext()) {
                String directory = (String)it.next();
                File tempFile = new File(directory, chromeFileName);
                if (!tempFile.exists()) continue;
                notFound = false;
                chromiumFile = tempFile;
            }
            if (chromiumFile == null && PlatformUtil.isWindows()) {
                File tempFile;
                path = WindowsRegistryUtil.readKeyValue(CHROME_WINDOWS_REG_HKCU_LOCATION, CHROME_WINDOWS_REG_KEY_NAME);
                if (path == null) {
                    path = WindowsRegistryUtil.readKeyValue(CHROME_WINDOWS_REG_HKLM_LOCATION, CHROME_WINDOWS_REG_KEY_NAME);
                }
                if (path != null && (tempFile = new File(path, chromeFileName)).exists()) {
                    notFound = false;
                    chromiumFile = tempFile;
                }
            }
            return chromiumFile;
        }
        chromiumFile = new File(output);
        return chromiumFile;
    }

    private static String detectChromiumOnMacOs() {
        String detectedPath = EMPTY;
        if (new File(MAC_CHROMIUM_PATH).exists()) {
            detectedPath = MAC_CHROMIUM_PATH;
        } else if (new File(MAC_CHROME_PATH).exists()) {
            detectedPath = MAC_CHROME_PATH;
        } else if (new File(MAC_CANARY_PATH).exists()) {
            detectedPath = MAC_CANARY_PATH;
        }
        return detectedPath;
    }

    private static String locateSystemCommandPath(String commandName) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        if (PlatformUtil.isWindows()) {
            cmdLine.add("cmd");
            cmdLine.add("/c");
            cmdLine.add(WHERE_COMMAND);
        } else {
            cmdLine.add(WHICH_LOCATION_1);
        }
        cmdLine.add(commandName);
        String output = ChromiumDetector.executeCmd(cmdLine);
        if (!PlatformUtil.isWindows() && output.equals(EMPTY)) {
            cmdLine.remove(0);
            cmdLine.add(0, WHICH_LOCATION_2);
            output = ChromiumDetector.executeCmd(cmdLine);
            if (output.equals(EMPTY)) {
                cmdLine.remove(0);
                cmdLine.add(0, WHICH_LOCATION_3);
                output = ChromiumDetector.executeCmd(cmdLine);
            }
        }
        return output;
    }

    private static String executeCmd(List<String> commands) {
        String output = EMPTY;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(commands);
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream));
            int exit = process.waitFor();
            if (exit == 0) {
                output = buffer.readLine();
            }
        }
        catch (Exception exception) {}
        return output;
    }
}

