/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor.search.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.xtend.shared.ui.core.action.SelectionDispatchAction;
import org.eclipse.xtend.shared.ui.editor.AbstractXtendXpandEditor;
import org.eclipse.xtend.shared.ui.editor.search.actions.FindReferencesAction;
import org.eclipse.xtend.shared.ui.editor.search.actions.Messages;

public class ReferencesSearchGroup
extends ActionGroup {
    private final IWorkbenchSite site;
    private IActionBars actionBars;
    private final String groupId;
    private SelectionDispatchAction findReferencesAction;

    public ReferencesSearchGroup(IWorkbenchSite site) {
        this.site = site;
        this.groupId = "group.search";
        this.findReferencesAction = new FindReferencesAction(site);
        this.findReferencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.references.in.workspace");
        ISelectionProvider provider = site.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.registerAction(this.findReferencesAction, provider, selection);
    }

    protected ReferencesSearchGroup(AbstractXtendXpandEditor editor) {
        Assert.isNotNull((Object)((Object)editor));
        this.site = editor.getSite();
        this.groupId = "group.find";
        this.findReferencesAction = new FindReferencesAction(editor);
        this.findReferencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.references.in.workspace");
        editor.setAction("SearchReferencesInWorkspace", (IAction)this.findReferencesAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    private void addAction(IAction action, IMenuManager manager) {
        if (action.isEnabled()) {
            manager.add(action);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.actionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager menuManager = new MenuManager(Messages.ReferencesSearchGroup_Label, "group.search");
        this.addAction((IAction)this.findReferencesAction, (IMenuManager)menuManager);
        menuManager.add((IContributionItem)new Separator());
        if (!menuManager.isEmpty()) {
            manager.appendToGroup(this.groupId, (IContributionItem)menuManager);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.site.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.findReferencesAction, provider);
        }
        this.findReferencesAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ReferencesInWorkspace", (IAction)this.findReferencesAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

