/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolutionFoundListener;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptToSatAdapter
extends SolverDecorator<ISolver> {
    private static final long serialVersionUID = 1L;
    IOptimizationProblem problem;
    boolean optimalValueForced = false;
    private final IVecInt assumps = new VecInt();
    private long begin;
    private final SolutionFoundListener sfl;

    public OptToSatAdapter(IOptimizationProblem problem) {
        this(problem, SolutionFoundListener.VOID);
    }

    public OptToSatAdapter(IOptimizationProblem problem, SolutionFoundListener sfl) {
        super((ISolver)((Object)problem));
        this.problem = problem;
        this.sfl = sfl;
    }

    @Override
    public void reset() {
        super.reset();
        this.optimalValueForced = false;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(boolean global) throws TimeoutException {
        return this.isSatisfiable();
    }

    @Override
    public boolean isSatisfiable(IVecInt myAssumps, boolean global) throws TimeoutException {
        return this.isSatisfiable(myAssumps);
    }

    @Override
    public boolean isSatisfiable(IVecInt myAssumps) throws TimeoutException {
        this.assumps.clear();
        myAssumps.copyTo(this.assumps);
        this.begin = System.currentTimeMillis();
        if (this.problem.hasNoObjectiveFunction()) {
            return this.problem.isSatisfiable(myAssumps);
        }
        boolean satisfiable = false;
        try {
            while (this.problem.admitABetterSolution(myAssumps)) {
                satisfiable = true;
                this.sfl.onSolutionFound(this.problem.model());
                this.problem.discardCurrentSolution();
                if (!this.isVerbose()) continue;
                System.out.println(String.valueOf(this.getLogPrefix()) + "Current objective function value: " + this.problem.getObjectiveValue() + "(" + (double)(System.currentTimeMillis() - this.begin) / 1000.0 + "s)");
            }
            this.sfl.onUnsatTermination();
        }
        catch (TimeoutException e) {
            if (this.isVerbose()) {
                System.out.println(String.valueOf(this.getLogPrefix()) + "Solver timed out after " + (double)(System.currentTimeMillis() - this.begin) / 1000.0 + "s)");
            }
            if (!satisfiable) {
                throw e;
            }
        }
        catch (ContradictionException contradictionException) {
            this.sfl.onUnsatTermination();
        }
        return satisfiable;
    }

    @Override
    public int[] model() {
        return this.problem.model();
    }

    @Override
    public boolean model(int var) {
        return this.problem.model(var);
    }

    @Override
    public int[] modelWithInternalVariables() {
        return this.decorated().modelWithInternalVariables();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        if (this.isSatisfiable()) {
            return this.model();
        }
        return null;
    }

    @Override
    public int[] findModel(IVecInt assumps) throws TimeoutException {
        if (this.isSatisfiable(assumps)) {
            return this.model();
        }
        return null;
    }

    @Override
    public String toString(String prefix) {
        return String.valueOf(prefix) + "Optimization to SAT adapter\n" + super.toString(prefix);
    }

    public boolean isOptimal() {
        return this.problem.isOptimal();
    }
}

