/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation.validators;

import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.ComplexGateway;
import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.modeler.core.validation.validators.AbstractBpmn2ElementValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;

public class GatewayValidator
extends AbstractBpmn2ElementValidator<Gateway> {
    public GatewayValidator(IValidationContext ctx) {
        super(ctx);
    }

    public GatewayValidator(AbstractBpmn2ElementValidator parent) {
        super(parent);
    }

    @Override
    public IStatus validate(Gateway object) {
        GatewayDirection direction = object.getGatewayDirection();
        int incoming = object.getIncoming().size();
        int outgoing = object.getOutgoing().size();
        if (direction == GatewayDirection.CONVERGING) {
            if (incoming < 1) {
                this.ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
                this.addStatus((EObject)object, "gatewayDirection", 4, Messages.GatewayValidator_Converging_Multiple_Incoming, new Object[0]);
            }
            if (outgoing > 1) {
                this.ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
                this.addStatus((EObject)object, "gatewayDirection", 4, Messages.GatewayValidator_Converging_One_Outgoing, new Object[0]);
            }
        } else if (direction == GatewayDirection.DIVERGING) {
            if (incoming > 1) {
                this.ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
                this.addStatus((EObject)object, "gatewayDirection", 4, Messages.GatewayValidator_Diverging_One_Incoming, new Object[0]);
            }
            if (outgoing < 1) {
                this.ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
                this.addStatus((EObject)object, "gatewayDirection", 4, Messages.GatewayValidator_Diverging_Multiple_Outgoing, new Object[0]);
            }
        } else if (direction == GatewayDirection.MIXED) {
            if (incoming < 1) {
                this.ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
                this.addStatus((EObject)object, "gatewayDirection", 4, Messages.GatewayValidator_Mixed_Multiple_Incoming, new Object[0]);
            }
            if (outgoing < 1) {
                this.ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
                this.addStatus((EObject)object, "gatewayDirection", 4, Messages.GatewayValidator_Mixed_Multiple_Outgoing, new Object[0]);
            }
        } else if (outgoing < 1 && incoming < 1) {
            this.ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
            this.addStatus((EObject)object, "gatewayDirection", 4, Messages.GatewayValidator_Unspecified_Multiple_Incoming_Outgoing, new Object[0]);
        }
        if (direction != GatewayDirection.MIXED) {
            if (object instanceof ExclusiveGateway && direction != GatewayDirection.DIVERGING && direction != GatewayDirection.CONVERGING) {
                this.addStatus((EObject)object, "gatewayDirection", 4, Messages.GatewayValidator_Exclusive_Converging_Diverging, new Object[0]);
            }
            if (object instanceof EventBasedGateway && direction != GatewayDirection.DIVERGING) {
                this.addStatus((EObject)object, "gatewayDirection", 4, Messages.GatewayValidator_Event_Diverging, new Object[0]);
            }
            if (object instanceof ParallelGateway && direction != GatewayDirection.DIVERGING && direction != GatewayDirection.CONVERGING) {
                this.addStatus((EObject)object, "gatewayDirection", 4, Messages.GatewayValidator_Parallel_Converging_Diverging, new Object[0]);
            }
            if (object instanceof InclusiveGateway && direction != GatewayDirection.DIVERGING && direction != GatewayDirection.CONVERGING) {
                this.addStatus((EObject)object, "gatewayDirection", 4, Messages.GatewayValidator_Inclusive_Converging_Diverging, new Object[0]);
            }
            if (object instanceof ComplexGateway && direction != GatewayDirection.DIVERGING && direction != GatewayDirection.CONVERGING) {
                this.addStatus((EObject)object, "gatewayDirection", 4, Messages.GatewayValidator_Complex_Converging_Diverging, new Object[0]);
            }
        }
        return this.getResult();
    }
}

