/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.editor;

import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.cdt.internal.qt.ui.Activator;
import org.eclipse.cdt.internal.qt.ui.editor.QtProjectFileKeyword;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class QtProjectFileContentAssistProcessor
implements IContentAssistProcessor {
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private final ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            IDocument document = viewer.getDocument();
            ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
            String prefix = this.lastWord(document, offset).toLowerCase(Locale.ROOT);
            QtProjectFileKeyword[] qtProjectFileKeywordArray = QtProjectFileKeyword.values();
            int n = qtProjectFileKeywordArray.length;
            int n2 = 0;
            while (n2 < n) {
                QtProjectFileKeyword keyword = qtProjectFileKeywordArray[n2];
                if (prefix.isEmpty() || keyword.getKeyword().toLowerCase(Locale.ROOT).startsWith(prefix)) {
                    result.add(new CompletionProposal(keyword.getKeyword(), offset - prefix.length(), prefix.length(), keyword.getKeyword().length()));
                }
                ++n2;
            }
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        catch (Exception e) {
            Activator.log(e);
            return this.NO_COMPLETIONS;
        }
    }

    private String lastWord(IDocument document, int offset) {
        try {
            int n = offset - 1;
            while (n >= 0) {
                char c = document.getChar(n);
                if (!Character.isJavaIdentifierPart(c)) {
                    return document.get(n + 1, offset - n - 1);
                }
                --n;
            }
            return document.get(0, offset);
        }
        catch (BadLocationException e) {
            Activator.log(e);
            return "";
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.NO_CONTEXTS;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }
}

