/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.internal.ui.buildconsole.GlobalBuildConsoleManager;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GlobalBuildLogPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public GlobalBuildLogPreferencePage() {
        super(1);
        this.setPreferenceStore(GlobalBuildConsoleManager.getBuildLogPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        BooleanFieldEditor keepLog = new BooleanFieldEditor("keepLog", PreferencesMessages.GlobalBuildLogPreferencePage_EnableLogging, parent);
        this.addField((FieldEditor)keepLog);
        FilePathEditor logLocation = new FilePathEditor("logLocation", PreferencesMessages.GlobalBuildLogPreferencePage_LogLocation, parent);
        this.addField((FieldEditor)logLocation);
    }

    public void init(IWorkbench workbench) {
        GlobalBuildLogPreferencePage.initDefaults(GlobalBuildConsoleManager.getBuildLogPreferenceStore());
    }

    public static void initDefaults(IPreferenceStore prefs) {
        prefs.setDefault("keepLog", true);
        prefs.setDefault("logLocation", GlobalBuildConsoleManager.getDefaultConsoleLogLocation());
    }

    private static class FilePathEditor
    extends StringButtonFieldEditor {
        public FilePathEditor(String name, String label, Composite parent) {
            super(name, label, parent);
        }

        protected String changePressed() {
            FileDialog dialog = new FileDialog(this.getShell(), 0);
            dialog.setText(this.getLabelText());
            String fileName = this.oldValue;
            IPath logFolder = new Path(fileName).removeLastSegments(1);
            dialog.setFilterPath(logFolder.toOSString());
            return dialog.open();
        }
    }
}

