/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.flow.util;

import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.eef.codegen.core.util.EMFHelper;

public class GenmodelHelper {
    private static final String EDITOR_SUFFIX = "editor";
    private static final String PLATFORM_RESOURCE_SCHEME = "platform:/resource";
    private static final String GENMODEL_EXTENSION = "genmodel";
    private static final String EEF_MODELS_PATH = "models";
    private static final String COMPONENTS_FILE_EXTENSION = "components";
    private static final String EEFGEN_FILE_EXTENSION = "eefgen";
    private IFile ecoreModel;
    private IContainer targetFolder;
    private ResourceSet resourceSet;
    private URI ecoreModelURI;
    private GenModel genmodel;
    private URI genmodelURI;

    public GenmodelHelper(ResourceSet resourceSet, IFile ecoreModel, IContainer targetFolder) {
        this.ecoreModel = ecoreModel;
        this.targetFolder = targetFolder;
        this.resourceSet = resourceSet;
    }

    public IContainer getTargetFolder() {
        return this.targetFolder;
    }

    public IFile getEcoreModel() {
        return this.ecoreModel;
    }

    public URI ecoreModelURI() {
        return this.computeEcoreModelURI();
    }

    public IFile getGenModelFile() {
        return this.targetFolder.getFile((IPath)new Path(this.genmodelFileName()));
    }

    public URI genmodelURI() {
        if (this.genmodelURI == null) {
            this.genmodelURI = GenmodelHelper.computeGenmodelURI(this.targetFolder, this.genmodelFileName());
        }
        return this.genmodelURI;
    }

    public GenModel getGenModel() {
        if (this.genmodel == null) {
            this.genmodel = this.loadGenmodel();
        }
        return this.genmodel;
    }

    public IFolder getEEFModelsFolder() {
        IProject editProject = this.targetFolder.getWorkspace().getRoot().getProject(this.getGenModel().getEditPluginID());
        IFolder modelsFolder = editProject.getFolder((IPath)new Path(this.eefmodelsFolderPath()));
        return modelsFolder;
    }

    public String eefmodelsFolderPath() {
        return EEF_MODELS_PATH;
    }

    public IFile getEEFPropertiesComponentsModel() {
        return this.getEEFModelsFolder().getFile((IPath)new Path(this.genmodelURI().trimFileExtension().appendFileExtension(COMPONENTS_FILE_EXTENSION).lastSegment()));
    }

    public IFile getEEFPropertiesEEFGenModel() {
        return this.getEEFModelsFolder().getFile((IPath)new Path(this.genmodelURI().trimFileExtension().appendFileExtension(EEFGEN_FILE_EXTENSION).lastSegment()));
    }

    public IFile getEEFEditorComponentsModel() {
        return this.getEEFModelsFolder().getFile((IPath)new Path(String.valueOf(this.genmodelURI().trimFileExtension().lastSegment()) + "-" + EDITOR_SUFFIX + "." + COMPONENTS_FILE_EXTENSION));
    }

    public IFile getEEFEditorEEFGenModel() {
        return this.getEEFModelsFolder().getFile((IPath)new Path(String.valueOf(this.genmodelURI().trimFileExtension().lastSegment()) + "-" + EDITOR_SUFFIX + "." + EEFGEN_FILE_EXTENSION));
    }

    public IFolder getEMFModelSrcFolder() {
        if (this.getGenModel() != null) {
            return this.targetFolder.getWorkspace().getRoot().getFolder((IPath)new Path(this.getGenModel().getModelDirectory()));
        }
        return null;
    }

    public IFolder getEMFEditSrcFolder() {
        if (this.getGenModel() != null) {
            return this.targetFolder.getWorkspace().getRoot().getFolder((IPath)new Path(this.getGenModel().getEditDirectory()));
        }
        return null;
    }

    public IFolder getEMFEditorSrcFolder() {
        if (this.getGenModel() != null) {
            return this.targetFolder.getWorkspace().getRoot().getFolder((IPath)new Path(this.getGenModel().getEditorDirectory()));
        }
        return null;
    }

    private URI computeEcoreModelURI() {
        if (this.ecoreModelURI == null) {
            this.ecoreModelURI = URI.createURI((String)(PLATFORM_RESOURCE_SCHEME + this.ecoreModel.getFullPath()));
        }
        return this.ecoreModelURI;
    }

    public static URI computeGenmodelURI(IContainer targetFolder, String genmodelFileName) {
        return URI.createPlatformResourceURI((String)(targetFolder.getFullPath() + "/" + genmodelFileName), (boolean)true);
    }

    public String genmodelFileName() {
        return this.ecoreModelURI().trimFileExtension().appendFileExtension(GENMODEL_EXTENSION).lastSegment();
    }

    private GenModel loadGenmodel() {
        try {
            URI genmodelURI = this.genmodelURI();
            EObject model = EMFHelper.load(genmodelURI, this.resourceSet);
            if (model instanceof GenModel) {
                return (GenModel)model;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public static URI computePropertiesComponentsModelURI(IContainer targetFolder, URI genmodelURI) {
        return URI.createPlatformResourceURI((String)(targetFolder.getFullPath() + "/" + genmodelURI.trimFileExtension().appendFileExtension(COMPONENTS_FILE_EXTENSION).lastSegment()), (boolean)false);
    }

    public static URI computePropertiesEEFGenModelURI(IContainer targetFolder, URI genmodelURI) {
        return URI.createPlatformResourceURI((String)(targetFolder.getFullPath() + "/" + genmodelURI.trimFileExtension().appendFileExtension(EEFGEN_FILE_EXTENSION).lastSegment()), (boolean)false);
    }

    public static URI computeEditorComponentsModelURI(IContainer targetFolder, URI genmodelURI) {
        return URI.createPlatformResourceURI((String)(targetFolder.getFullPath() + "/" + genmodelURI.trimFileExtension().lastSegment() + "-" + EDITOR_SUFFIX + "." + COMPONENTS_FILE_EXTENSION), (boolean)false);
    }

    public static URI computeEditorEEFGenModelURI(IContainer targetFolder, URI genmodelURI) {
        return URI.createPlatformResourceURI((String)(targetFolder.getFullPath() + "/" + genmodelURI.trimFileExtension().lastSegment() + "-" + EDITOR_SUFFIX + "." + EEFGEN_FILE_EXTENSION), (boolean)false);
    }
}

