/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.ui.internal.navigator;

import java.util.Iterator;
import org.eclipse.jpt.common.ui.jface.ItemStructuredContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SuperIterableWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.FilteringCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListCurator;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.TypeKind;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaType;
import org.eclipse.jpt.jaxb.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELJaxbPackage;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmFile;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlEnum;
import org.eclipse.jpt.jaxb.ui.internal.AbstractNavigatorItemContentProviderFactory;

public class ELJaxbNavigatorItemContentProviderFactory
extends AbstractNavigatorItemContentProviderFactory {
    private static ELJaxbNavigatorItemContentProviderFactory INSTANCE = new ELJaxbNavigatorItemContentProviderFactory();

    public static ELJaxbNavigatorItemContentProviderFactory instance() {
        return INSTANCE;
    }

    private ELJaxbNavigatorItemContentProviderFactory() {
    }

    public ItemStructuredContentProvider buildProvider(Object input, ItemStructuredContentProvider.Manager manager) {
        if (input instanceof OxmFile) {
            return this.buildItemStructuredContentProvider(input, this.buildOxmFileChildrenModel((OxmFile)input), manager);
        }
        if (input instanceof OxmJavaType) {
            return this.buildItemStructuredContentProvider(input, this.buildOxmJavaTypeChildrenModel((OxmJavaType)input), manager);
        }
        return super.buildProvider(input, manager);
    }

    public ItemTreeContentProvider buildProvider(Object item, Object parent, ItemTreeContentProvider.Manager manager) {
        if (item instanceof OxmFile) {
            return this.buildItemTreeContentProvider(item, parent, this.buildOxmFileChildrenModel((OxmFile)item), manager);
        }
        if (item instanceof OxmJavaType) {
            return this.buildItemTreeContentProvider(item, parent, this.buildOxmJavaTypeChildrenModel((OxmJavaType)item), manager);
        }
        return super.buildProvider(item, parent, manager);
    }

    protected CollectionValueModel<JaxbContextNode> buildJaxbPackageChildrenModel(JaxbPackage jaxbPackage) {
        return CompositeCollectionValueModel.forModels((CollectionValueModel[])new CollectionValueModel[]{this.buildOxmFileChildrenModel((ELJaxbPackage)jaxbPackage), this.buildJavaTypeChildrenModel((ELJaxbPackage)jaxbPackage)});
    }

    protected CollectionValueModel<JaxbContextNode> buildOxmFileChildrenModel(ELJaxbPackage jaxbPackage) {
        return new FilteringCollectionValueModel((CollectionValueModel)new PropertyCollectionValueModelAdapter((PropertyValueModel)new PropertyAspectAdapter<ELJaxbPackage, JaxbContextNode>("oxmFile", jaxbPackage){

            protected JaxbContextNode buildValue_() {
                return ((ELJaxbPackage)this.subject).getOxmFile();
            }
        }), PredicateTools.isNotNull());
    }

    protected CollectionValueModel<JaxbContextNode> buildJavaTypeChildrenModel(final ELJaxbPackage jaxbPackage) {
        return new ListCollectionValueModelAdapter((ListValueModel)new ListCurator<JaxbContextRoot, JaxbContextNode>(jaxbPackage.getContextRoot()){

            protected Iterator<JaxbContextNode> iteratorForRecord() {
                return new SuperIterableWrapper(IterableTools.filter((Iterable)((JaxbContextRoot)this.subject).getJavaTypes((JaxbPackage)jaxbPackage), (Predicate)new IsJavaType((JaxbContextRoot)this.subject))).iterator();
            }
        });
    }

    protected CollectionValueModel<JaxbContextNode> buildOxmFileChildrenModel(OxmFile oxmFile) {
        return new ListCollectionValueModelAdapter((ListValueModel)CompositeListValueModel.forModels((ListValueModel[])new ListAspectAdapter[]{new ListAspectAdapter<OxmXmlBindings, OxmXmlEnum>(this.buildXmlBindingsModel(oxmFile), new String[]{"xmlEnums"}){

            protected ListIterable<OxmXmlEnum> getListIterable() {
                return ((OxmXmlBindings)this.subject).getXmlEnums();
            }

            public int size() {
                return ((OxmXmlBindings)this.subject).getXmlEnumsSize();
            }
        }, new ListAspectAdapter<OxmXmlBindings, OxmJavaType>(this.buildXmlBindingsModel(oxmFile), new String[]{"javaTypes"}){

            protected ListIterable<OxmJavaType> getListIterable() {
                return ((OxmXmlBindings)this.subject).getJavaTypes();
            }

            protected int size_() {
                return ((OxmXmlBindings)this.subject).getJavaTypesSize();
            }
        }}));
    }

    protected PropertyValueModel<OxmXmlBindings> buildXmlBindingsModel(OxmFile oxmFile) {
        return new PropertyAspectAdapter<OxmFile, OxmXmlBindings>("xmlBindings", oxmFile){

            protected OxmXmlBindings buildValue_() {
                return ((OxmFile)this.subject).getXmlBindings();
            }
        };
    }

    public CollectionValueModel<?> buildOxmJavaTypeChildrenModel(OxmJavaType oxmJavaType) {
        return new ListCollectionValueModelAdapter((ListValueModel)new ItemPropertyListValueModelAdapter((ListValueModel)new ListAspectAdapter<OxmJavaType, OxmJavaAttribute>("specifiedAttributes", oxmJavaType){

            protected ListIterable<OxmJavaAttribute> getListIterable() {
                return ((OxmJavaType)this.subject).getSpecifiedAttributes();
            }

            protected int size_() {
                return ((OxmJavaType)this.subject).getSpecifiedAttributesSize();
            }
        }, new String[0]));
    }

    public static class IsJavaType
    extends CriterionPredicate<JavaType, JaxbContextRoot> {
        public IsJavaType(JaxbContextRoot contextRoot) {
            super((Object)contextRoot);
        }

        public boolean evaluate(JavaType o) {
            String typeName = o.getTypeName().getFullyQualifiedName();
            JavaTypeMapping typeMapping = o.getMapping();
            if (typeMapping != null && ((JaxbContextRoot)this.criterion).getTypeMapping(typeName) == typeMapping) {
                return true;
            }
            if (o.getXmlJavaTypeAdapter() != null) {
                return true;
            }
            return o.getKind() == TypeKind.CLASS && ((JavaClass)o).getXmlRegistry() != null;
        }
    }
}

