/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov.user.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.UserLibraryManager;
import org.eclipse.jst.common.project.facet.core.libprov.user.internal.DownloadableLibraryComponentAttributes;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.util.internal.ZipUtil;

public final class DownloadableLibrary {
    private String name;
    private String downloadProvider;
    private String url;
    private String licenseUrl;
    private Map<IPath, DownloadableLibraryComponentAttributes> componentAttributesMap = new HashMap<IPath, DownloadableLibraryComponentAttributes>();
    private final List<String> includePatterns = new ArrayList<String>();
    private final List<String> includePatternsReadOnly = Collections.unmodifiableList(this.includePatterns);
    private final List<String> excludePatterns = new ArrayList<String>();
    private final List<String> excludePatternsReadOnly = Collections.unmodifiableList(this.excludePatterns);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDownloadProvider() {
        return this.downloadProvider;
    }

    public void setDownloadProvider(String downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public DownloadableLibraryComponentAttributes getComponentAttributes(IPath path) {
        return this.getComponentAttributes(path, false);
    }

    public DownloadableLibraryComponentAttributes getComponentAttributes(IPath path, boolean createIfNecessary) {
        DownloadableLibraryComponentAttributes attachment = this.componentAttributesMap.get(path);
        if (attachment == null && createIfNecessary) {
            attachment = new DownloadableLibraryComponentAttributes(path.toPortableString());
            this.componentAttributesMap.put(path, attachment);
        }
        return attachment;
    }

    public Collection<String> getIncludePatterns() {
        return this.includePatternsReadOnly;
    }

    public void addIncludePattern(String includePattern) {
        if (includePattern == null) {
            return;
        }
        String[] stringArray = includePattern.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if ((segment = segment.trim()).length() > 0) {
                this.includePatterns.add(segment);
            }
            ++n2;
        }
    }

    public Collection<String> getExcludePatterns() {
        return this.excludePatternsReadOnly;
    }

    public void addExcludePattern(String excludePattern) {
        if (excludePattern == null) {
            return;
        }
        String[] stringArray = excludePattern.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if ((segment = segment.trim()).length() > 0) {
                this.excludePatterns.add(segment);
            }
            ++n2;
        }
    }

    public void download(File destFolder, String localLibraryName, IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            destFolder.mkdirs();
            File[] fileArray = destFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                DownloadableLibrary.delete(f);
                ++n2;
            }
            File destFile = new File(destFolder, "download.zip");
            this.download(new URL(this.url), destFile, monitor);
            ZipUtil.unzip((File)destFile, (File)destFolder, (IProgressMonitor)monitor);
            destFile.delete();
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
            Path destFolderPath = new Path(destFolder.getPath());
            for (File jarFile : DownloadableLibrary.findAllJarFiles(destFolder)) {
                Path jarPath = new Path(jarFile.getPath());
                IPath relativeJarPath = jarPath.makeRelativeTo((IPath)destFolderPath);
                if (!this.shouldInclude(relativeJarPath)) continue;
                IPath sourceArchivePath = null;
                String javadocArchivePath = null;
                DownloadableLibraryComponentAttributes attachment = this.getComponentAttributes(relativeJarPath);
                if (attachment != null) {
                    String sourceArchivePathString = attachment.getSourceArchivePath();
                    if (sourceArchivePathString != null) {
                        sourceArchivePath = destFolderPath.append(sourceArchivePathString);
                    }
                    if ((javadocArchivePath = attachment.getJavadocArchivePath()) != null) {
                        Path pathInArchive;
                        int separator = javadocArchivePath.indexOf(33);
                        if (separator == -1) {
                            pathInArchive = null;
                        } else {
                            pathInArchive = new Path(javadocArchivePath.substring(separator + 1));
                            javadocArchivePath = javadocArchivePath.substring(0, separator);
                        }
                        IPath p = destFolderPath.append(javadocArchivePath);
                        if (pathInArchive != null || p.toFile().isFile()) {
                            javadocArchivePath = "jar:file:/" + p.toPortableString() + "!/";
                            if (javadocArchivePath != null) {
                                javadocArchivePath = String.valueOf(javadocArchivePath) + pathInArchive.toPortableString() + "/";
                            }
                        } else {
                            javadocArchivePath = "file:/" + p.toPortableString() + "/";
                        }
                    }
                }
                IClasspathEntry cpe = DownloadableLibrary.newLibraryEntry((IPath)jarPath, sourceArchivePath, javadocArchivePath);
                entries.add(cpe);
            }
            IClasspathEntry[] entriesArray = entries.toArray(new IClasspathEntry[entries.size()]);
            UserLibraryManager userLibraryManager = JavaModelManager.getUserLibraryManager();
            userLibraryManager.setUserLibrary(localLibraryName, entriesArray, false);
        }
        catch (IOException e) {
            Status st = new Status(4, "org.eclipse.jst.common.project.facet.core", Resources.failedWhileDownloading, (Throwable)e);
            throw new CoreException((IStatus)st);
        }
    }

    private void download(URL url, File destFile, IProgressMonitor monitor) throws IOException, InterruptedException {
        String totalSizeString;
        monitor.setTaskName(Resources.progressConnecting);
        URLConnection urlConnection = url.openConnection();
        int size = urlConnection.getContentLength();
        if (size == -1) {
            totalSizeString = null;
            monitor.beginTask(Resources.progressTransferStarted, -1);
        } else {
            totalSizeString = this.formatByteCount(size);
            monitor.beginTask(Resources.progressTransferStarted, size);
        }
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = urlConnection.getInputStream();
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[16384];
            int count = 0;
            int bytesTransfered = 0;
            while ((count = in.read(buffer)) != -1) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                out.write(buffer, 0, count);
                monitor.worked(count);
                monitor.setTaskName(this.formatDownloadProgressMessage(bytesTransfered += count, totalSizeString));
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            monitor.done();
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        monitor.done();
    }

    private boolean shouldInclude(IPath path) {
        if (!this.includePatterns.isEmpty()) {
            boolean included = false;
            for (String pattern : this.includePatterns) {
                if (!path.equals((Object)new Path(pattern))) continue;
                included = true;
                break;
            }
            if (!included) {
                return false;
            }
        }
        for (String pattern : this.excludePatterns) {
            if (!path.equals((Object)new Path(pattern))) continue;
            return false;
        }
        return true;
    }

    private String formatByteCount(int byteCount) {
        if (byteCount < 0x100000) {
            return String.format("%3.0f KB", Float.valueOf((float)byteCount / 1024.0f));
        }
        return String.format("%.1f MB", Float.valueOf((float)byteCount / 1048576.0f));
    }

    private String formatDownloadProgressMessage(int bytesTransfered, String totalSizeString) {
        String bytesTransferedString = this.formatByteCount(bytesTransfered);
        if (totalSizeString != null) {
            return NLS.bind((String)Resources.progressTransferred, (Object)bytesTransferedString, (Object)totalSizeString);
        }
        return NLS.bind((String)Resources.progressTransferredNoTotalSize, (Object)bytesTransferedString);
    }

    private static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                DownloadableLibrary.delete(child);
                ++n2;
            }
        }
        if (!f.delete()) {
            String msg = NLS.bind((String)Resources.errorCouldNotDelete, (Object)f.getPath());
            throw new IOException(msg);
        }
    }

    private static List<File> findAllJarFiles(File directory) {
        ArrayList<File> result = new ArrayList<File>();
        DownloadableLibrary.findAllJarFiles(directory, result);
        return result;
    }

    private static void findAllJarFiles(File directory, List<File> result) {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                DownloadableLibrary.findAllJarFiles(f, result);
            } else {
                String fname = f.getName().toLowerCase();
                if (fname.endsWith(".jar")) {
                    result.add(f);
                }
            }
            ++n2;
        }
    }

    private static IClasspathEntry newLibraryEntry(IPath library, IPath src, String javadoc) {
        IAccessRule[] access = new IAccessRule[]{};
        IClasspathAttribute[] attrs = javadoc == null ? new IClasspathAttribute[]{} : new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadoc)};
        return JavaCore.newLibraryEntry((IPath)library, (IPath)src, null, (IAccessRule[])access, (IClasspathAttribute[])attrs, (boolean)false);
    }

    private static final class Resources
    extends NLS {
        public static String failedWhileDownloading;
        public static String progressConnecting;
        public static String progressTransferStarted;
        public static String progressTransferred;
        public static String progressTransferredNoTotalSize;
        public static String errorCouldNotDelete;

        static {
            Resources.initializeMessages((String)DownloadableLibrary.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

