/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IRegistry;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageNameValidator;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePullPage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;

public class ImagePull
extends Wizard {
    private final ImagePullPage imagePullPage;

    public ImagePull(IDockerConnection connection) {
        this.setWindowTitle(WizardMessages.getString("ImagePull.title"));
        this.imagePullPage = new ImagePullPage(connection);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.imagePullPage);
    }

    public boolean canFinish() {
        return this.imagePullPage.isPageComplete();
    }

    public boolean performFinish() {
        return true;
    }

    public String getSelectedImageName() {
        String selectedImageName = this.imagePullPage.getSelectedImageName();
        if (ImageNameValidator.getStatus(selectedImageName) == ImageNameValidator.ImageNameStatus.TAG_MISSING) {
            return String.valueOf(selectedImageName) + ':' + "latest";
        }
        return selectedImageName;
    }

    public IRegistry getSelectedRegistryAccount() {
        return this.imagePullPage.getSelectedRegistryAccount();
    }
}

