/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import java.io.IOException;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.m2e.editor.pom.PomTemplateContext;
import org.eclipse.m2e.editor.xml.MvnImages;
import org.eclipse.m2e.editor.xml.PomTemplateContextType;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MvnIndexPlugin
extends AbstractUIPlugin {
    private static final Logger log = LoggerFactory.getLogger(MvnIndexPlugin.class);
    public static final String PLUGIN_ID = "org.eclipse.m2e.editor.xml";
    private static final String TEMPLATES_KEY = "org.eclipse.m2e.editor.xml.templates";
    private static MvnIndexPlugin defaultInstance;
    private TemplateStore templateStore;
    private ContributionContextTypeRegistry contextTypeRegistry;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        defaultInstance = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        MvnImages.Custom.dispose();
        defaultInstance = null;
    }

    public static MvnIndexPlugin getDefault() {
        return defaultInstance;
    }

    public TemplateStore getTemplateStore() {
        if (this.templateStore == null) {
            this.templateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), TEMPLATES_KEY);
            try {
                this.templateStore.load();
            }
            catch (IOException ex) {
                log.error("Unable to load pom templates", (Throwable)ex);
            }
        }
        return this.templateStore;
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.contextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            PomTemplateContext[] pomTemplateContextArray = PomTemplateContext.values();
            int n = pomTemplateContextArray.length;
            int n2 = 0;
            while (n2 < n) {
                PomTemplateContext contextType = pomTemplateContextArray[n2];
                registry.addContextType(contextType.getContextTypeId());
                ++n2;
            }
            this.contextTypeRegistry = registry;
        }
        return this.contextTypeRegistry;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.contextTypeRegistry == null) {
            this.contextTypeRegistry = new ContributionContextTypeRegistry();
            PomTemplateContextType contextType = new PomTemplateContextType();
            this.contextTypeRegistry.addContextType((TemplateContextType)contextType);
        }
        return this.contextTypeRegistry;
    }
}

