/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.editor.internal.lifecycle.LifecycleMappingResolution;
import org.eclipse.m2e.editor.internal.lifecycle.WorkspaceLifecycleMappingResolution;
import org.eclipse.m2e.editor.internal.markers.IdPartRemovalResolution;
import org.eclipse.m2e.editor.internal.markers.IgnoreWarningResolution;
import org.eclipse.m2e.editor.internal.markers.ManagedVersionRemovalResolution;
import org.eclipse.m2e.editor.internal.markers.OpenManagedVersionDefinitionResolution;
import org.eclipse.m2e.editor.internal.markers.SchemaCompletionResolution;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class MavenMarkerResolutionGenerator
implements IMarkerResolutionGenerator,
IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        String hint = marker.getAttribute("editor_hint", null);
        if (hint == null) {
            return new IMarkerResolution[0];
        }
        if (MavenMarkerResolutionGenerator.isMissingSchema(hint)) {
            return new IMarkerResolution[]{new SchemaCompletionResolution(marker)};
        }
        if (MavenMarkerResolutionGenerator.isUnneededParentVersion(hint)) {
            return new IMarkerResolution[]{new IdPartRemovalResolution(marker, true)};
        }
        if (MavenMarkerResolutionGenerator.isUnneededParentGroupId(hint)) {
            return new IMarkerResolution[]{new IdPartRemovalResolution(marker, false)};
        }
        if (MavenMarkerResolutionGenerator.isDependencyVersionOverride(hint)) {
            return new IMarkerResolution[]{new ManagedVersionRemovalResolution(marker, true), new IgnoreWarningResolution(marker, "$NO-MVN-MAN-VER$"), new OpenManagedVersionDefinitionResolution(marker)};
        }
        if (MavenMarkerResolutionGenerator.isPluginVersionOverride(hint)) {
            return new IMarkerResolution[]{new ManagedVersionRemovalResolution(marker, false), new IgnoreWarningResolution(marker, "$NO-MVN-MAN-VER$"), new OpenManagedVersionDefinitionResolution(marker)};
        }
        if ("not_covered_mojo_execution".equals(hint)) {
            return new IMarkerResolution[]{new LifecycleMappingResolution(marker, PluginExecutionAction.ignore), new WorkspaceLifecycleMappingResolution(marker, PluginExecutionAction.ignore)};
        }
        if ("missing_configurator".equals(hint)) {
            return new IMarkerResolution[]{new LifecycleMappingResolution(marker, PluginExecutionAction.ignore), new WorkspaceLifecycleMappingResolution(marker, PluginExecutionAction.ignore)};
        }
        if (marker.getAttribute("severity", 2) == 2 && "implicit_lifecyclemaping".equals(hint)) {
            return new IMarkerResolution[]{new LifecycleMappingResolution(marker, PluginExecutionAction.ignore), new WorkspaceLifecycleMappingResolution(marker, PluginExecutionAction.ignore)};
        }
        return new IMarkerResolution[0];
    }

    static boolean isPluginVersionOverride(String hint) {
        return "managed_plugin_override".equals(hint);
    }

    static boolean isDependencyVersionOverride(String hint) {
        return "managed_dependency_override".equals(hint);
    }

    static boolean isUnneededParentGroupId(String hint) {
        return "parent_groupid".equals(hint);
    }

    static boolean isUnneededParentVersion(String hint) {
        return "parent_version".equals(hint);
    }

    static boolean isMissingSchema(String hint) {
        return "missing_schema".equals(hint);
    }

    public boolean hasResolutions(IMarker marker) {
        String hint = marker.getAttribute("editor_hint", null);
        return hint != null;
    }
}

