/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.logback.configuration;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.function.BooleanSupplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.SubstituteLoggerFactory;

public class LogPlugin
extends Plugin {
    private static final String PLUGIN_ID = "org.eclipse.m2e.logback.configuration";
    private static final String RESOURCES_PLUGIN_ID = "org.eclipse.core.resources";
    public static final String PROPERTY_LOG_DIRECTORY = "org.eclipse.m2e.log.dir";
    private boolean isConfigured;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (System.getProperty("logback.configurationFile") != null) {
            LogPlugin.systemOut("logback.configurationFile=" + System.getProperty("logback.configurationFile"));
            return;
        }
        if (!LogPlugin.isStateLocationInitialized()) {
            LogPlugin.systemOut("Activated before the state location was initialized. Retry after the state location is initialized.");
            LogPlugin.runConditionally(this::configureLogback, LogPlugin::isStateLocationInitialized, "logback configurator timer");
        } else {
            this.configureLogback();
        }
    }

    private synchronized void configureLogback() {
        if (this.isConfigured) {
            LogPlugin.systemOut("Logback was configured already");
            return;
        }
        try {
            File stateDir = this.getStateLocation().toFile();
            File configFile = new File(stateDir, "logback." + this.getBundle().getVersion() + ".xml");
            LogPlugin.systemOut("Logback config file: " + configFile.getAbsolutePath());
            if (!configFile.isFile()) {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream is = this.getBundle().getEntry("defaultLogbackConfiguration/logback.xml").openStream();){
                    configFile.getParentFile().mkdirs();
                    Files.copy(is, configFile.toPath(), new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (System.getProperty(PROPERTY_LOG_DIRECTORY, "").length() <= 0) {
                System.setProperty(PROPERTY_LOG_DIRECTORY, stateDir.getAbsolutePath());
            }
            LogPlugin.loadConfiguration(configFile.toURI().toURL());
            this.isConfigured = true;
        }
        catch (Exception e) {
            this.getLog().log((IStatus)Status.warning((String)("Exception while setting up logging:" + e.getMessage()), (Throwable)e));
        }
    }

    public static void loadConfiguration(URL configFile) throws JoranException {
        LoggerContext lc = LogPlugin.getLoggerContext();
        if (lc == null) {
            return;
        }
        LogPlugin.systemOut("Initializing logback");
        lc.reset();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        configurator.doConfigure(configFile);
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)lc);
        LogPlugin.logJavaProperties(LoggerFactory.getLogger(LogPlugin.class));
    }

    private static boolean isStateLocationInitialized() {
        if (!Platform.isRunning()) {
            return false;
        }
        Bundle resourcesBundle = Platform.getBundle((String)RESOURCES_PLUGIN_ID);
        return resourcesBundle != null && resourcesBundle.getState() == 32;
    }

    private static void runConditionally(final Runnable action, final BooleanSupplier condition, String name) {
        final Timer timer = new Timer(name);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (condition.getAsBoolean()) {
                    timer.cancel();
                    action.run();
                }
            }
        }, 0L, 50L);
    }

    private static LoggerContext getLoggerContext() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        int i = 0;
        while (loggerFactory instanceof SubstituteLoggerFactory && i < 100) {
            LogPlugin.systemOut("SLF4J logger factory class: " + loggerFactory.getClass().getName());
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            loggerFactory = LoggerFactory.getILoggerFactory();
            ++i;
        }
        if (loggerFactory instanceof LoggerContext) {
            return (LoggerContext)loggerFactory;
        }
        String msg = loggerFactory == null ? "SLF4J logger factory is null" : "SLF4J logger factory is not an instance of LoggerContext: " + loggerFactory.getClass().getName();
        LogPlugin.systemErr(msg);
        return null;
    }

    public static void logJavaProperties(Logger log) {
        Properties javaProperties = System.getProperties();
        TreeMap<String, String> sortedProperties = new TreeMap<String, String>();
        for (String key : javaProperties.stringPropertyNames()) {
            sortedProperties.put(key, javaProperties.getProperty(key));
        }
        log.debug("Java properties (ordered by property name):");
        sortedProperties.forEach((k, v) -> log.debug("   {}={}", k, v));
    }

    private static void systemOut(String message) {
        System.out.println("org.eclipse.m2e.logback.configuration: " + message);
    }

    private static void systemErr(String message) {
        System.err.println("org.eclipse.m2e.logback.configuration: " + message);
    }
}

