/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.AtlTypesProcessor;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.CollectionType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Feature;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.MapType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.ModelElementType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclAnyType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.TupleType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operation
extends Feature {
    private static final String BUNDLE_NAME = "org.eclipse.m2m.atl.adt.ui.text.atl.types.description";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.eclipse.m2m.atl.adt.ui.text.atl.types.description");
    private Map<String, OclAnyType> parameters;

    public Operation(String name, OclAnyType contextType, OclAnyType type, Map<String, OclAnyType> parameters) {
        super(null, null, name, contextType, type, false, false, 1, 1);
        this.parameters = parameters;
        this.setImagePath("$nl$/icons/operation.gif");
    }

    public Operation(String name, OclAnyType contextType, OclAnyType type) {
        super(null, null, name, contextType, type, false, false, 1, 1);
        this.parameters = Collections.emptyMap();
        this.setImagePath("$nl$/icons/operation.gif");
    }

    public Operation(UnitType unit, EObject declaration, String name, OclAnyType contextType, OclAnyType type, Map<String, OclAnyType> parameters) {
        super(unit, declaration, name, contextType, type, false, false, 1, 1);
        this.parameters = parameters;
        this.setImagePath("$nl$/icons/operation.gif");
    }

    public Operation(UnitType unit, EObject declaration, String name, OclAnyType contextType, OclAnyType type) {
        super(unit, declaration, name, contextType, type, false, false, 1, 1);
        this.parameters = Collections.emptyMap();
        this.setImagePath("$nl$/icons/operation.gif");
    }

    public Operation(EOperation operation, String metamodelName) {
        super(null, (EObject)operation, operation.getName(), ModelElementType.create((EClassifier)operation.getEContainingClass(), metamodelName), ModelElementType.create(operation.getEType(), metamodelName), operation.isOrdered(), false, operation.getLowerBound(), operation.getUpperBound());
        this.parameters = new LinkedHashMap<String, OclAnyType>();
        for (EParameter eParameter : operation.getEParameters()) {
            this.parameters.put(eParameter.getName().toLowerCase(), ModelElementType.create(eParameter.getEType(), metamodelName));
        }
        this.setImagePath("$nl$/icons/EOperation.gif");
    }

    public Map<String, OclAnyType> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Operation) {
            return this.toString().equals(((Operation)obj).toString());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        StringBuffer signature = new StringBuffer();
        signature.append(this.getName());
        signature.append('(');
        Iterator<Map.Entry<String, OclAnyType>> iterator = this.parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, OclAnyType> parameter = iterator.next();
            signature.append(parameter.getKey());
            signature.append(" : ");
            signature.append(parameter.getValue());
            if (!iterator.hasNext()) continue;
            signature.append(", ");
        }
        signature.append(')');
        return signature.toString();
    }

    public OclAnyType getType(OclAnyType context, Object ... parameters) {
        if (this.getType() != null) {
            return this.getType();
        }
        return context;
    }

    public String getDocumentation(OclAnyType context, Object ... parameters) {
        if (this.documentation == null) {
            String key = "";
            if (context instanceof CollectionType) {
                key = String.valueOf(((CollectionType)context).getCollectionType()) + '.';
            } else if (context instanceof MapType) {
                key = "Map.";
            } else if (context instanceof TupleType) {
                key = "Tuple.";
            } else if (context != null) {
                key = String.valueOf(context.toString()) + '.';
            }
            key = String.valueOf(key) + this.name;
            this.documentation = Operation.getMessage(key);
        }
        if (this.documentation != null && !this.documentation.trim().equals("")) {
            return this.documentation;
        }
        OclAnyType[] oclAnyTypeArray = context.getSupertypes();
        int n = oclAnyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OclAnyType supertype = oclAnyTypeArray[n2];
            this.documentation = this.getDocumentation(supertype, parameters);
            if (this.documentation != null) {
                return this.documentation;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getInformation(OclAnyType context) {
        StringBuffer information = new StringBuffer();
        information.append(this.getName());
        information.append('(');
        Iterator<Map.Entry<String, OclAnyType>> iterator = this.getParameters().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, OclAnyType> parameter = iterator.next();
            information.append(String.valueOf(parameter.getKey()) + " : " + parameter.getValue());
            if (!iterator.hasNext()) continue;
            information.append(", ");
        }
        information.append(')');
        if (this.getType(context, new Object[0]) != null) {
            information.append(" : " + this.getType(context, new Object[0]));
        }
        return information.toString();
    }

    private static String getMessage(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static Operation createFromRule(UnitType unit, EObject rule, OclAnyType context) {
        String ruleName = (String)AtlTypesProcessor.eGet(rule, "name");
        Object condition = AtlTypesProcessor.eGet(rule, "isAbstract");
        boolean isAbstract = false;
        if (condition != null) {
            isAbstract = Boolean.valueOf(condition.toString());
        }
        if (!isAbstract && ruleName != null) {
            HashMap<String, OclAnyType> parameters = new HashMap<String, OclAnyType>();
            EList parameterObjects = (EList)AtlTypesProcessor.eGet(rule, "parameters");
            if (parameterObjects != null) {
                for (EObject eObject : parameterObjects) {
                    String parameterName = (String)AtlTypesProcessor.eGet(eObject, "varName");
                    EObject parameterTypeObject = (EObject)AtlTypesProcessor.eGet(eObject, "type");
                    OclAnyType parameterType = OclAnyType.create(unit.getSourceManager(), parameterTypeObject);
                    parameters.put(parameterName, parameterType);
                }
            }
            Operation operation = new Operation(unit, rule, ruleName, context, OclAnyType.getInstance(), parameters);
            operation.setImagePath("$nl$/icons/operation.gif");
            String doc = Operation.getDocumentation(rule);
            if (doc != null && doc.length() > 0) {
                operation.setDocumentation(doc);
            }
            return operation;
        }
        return null;
    }

    public static Operation createFromCalledRule(UnitType unit, EObject rule, OclAnyType context) {
        Operation operation = Operation.createFromRule(unit, rule, context);
        if (operation != null) {
            operation.setImagePath("$nl$/icons/matchedRule.gif");
        }
        return operation;
    }

    public static Operation createFromLazyRule(UnitType unit, EObject rule, OclAnyType context) {
        Operation operation = Operation.createFromRule(unit, rule, context);
        if (operation != null) {
            operation.setImagePath("$nl$/icons/lazyRule.gif");
        }
        return operation;
    }

    public static Operation createFromHelper(UnitType unit, EObject helper, OclAnyType context) {
        String helperName = (String)AtlTypesProcessor.eGet(helper, "name");
        if (helperName != null) {
            String doc;
            LinkedHashMap<String, OclAnyType> parameters = new LinkedHashMap<String, OclAnyType>();
            EList parameterObjects = (EList)AtlTypesProcessor.eGet(helper, "parameters");
            if (parameterObjects != null) {
                for (EObject eObject : parameterObjects) {
                    String parameterName = (String)AtlTypesProcessor.eGet(eObject, "varName");
                    EObject parameterTypeObject = (EObject)AtlTypesProcessor.eGet(eObject, "type");
                    OclAnyType parameterType = OclAnyType.create(unit.getSourceManager(), parameterTypeObject);
                    parameters.put(parameterName, parameterType);
                }
            }
            EObject helperType = (EObject)AtlTypesProcessor.eGet(helper, "returnType");
            OclAnyType type = OclAnyType.create(unit.getSourceManager(), helperType);
            Operation operation = new Operation(unit, helper, helperName, context, type, parameters);
            operation.setImagePath("$nl$/icons/helper.gif");
            EObject container = helper.eContainer();
            if (container != null && (container = container.eContainer()) != null && (doc = Operation.getDocumentation(container)) != null && doc.length() > 0) {
                operation.setDocumentation(doc);
            }
            return operation;
        }
        return null;
    }
}

