/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.query;

import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.query.Icons;

public final class ObjectListResult {
    private ObjectListResult() {
    }

    public static class Inbound
    extends Tree {
        public Inbound(ISnapshot snapshot, int[] objectIds) {
            super(snapshot, objectIds);
        }

        @Override
        protected int[] children(Node node) throws SnapshotException {
            return this.snapshot.getInboundRefererIds(node.objectId);
        }

        @Override
        protected void fillInAttribute(LinkedNode node) throws SnapshotException {
            IObject heapObject = this.snapshot.getObject(node.objectId);
            long parentAddress = this.snapshot.mapIdToAddress(node.parent.objectId);
            node.attribute = this.extractAttribute(heapObject, parentAddress);
        }

        public URL getIcon(Object row) {
            if (row instanceof LinkedNode) {
                return Icons.inbound(this.snapshot, ((Node)row).objectId);
            }
            return Icons.forObject(this.snapshot, ((Node)row).objectId);
        }
    }

    private static class LazyList
    implements List<Node>,
    RandomAccess {
        int created = 0;
        private int[] objectIds;
        private Node[] elements;

        private LazyList(int[] objectIds) {
            this.objectIds = objectIds;
            this.elements = new Node[objectIds.length];
        }

        @Override
        public Node get(int index) {
            if (index < 0 || index >= this.objectIds.length) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            if (this.elements[index] == null) {
                this.elements[index] = new Node(this.objectIds[index], null, null);
                ++this.created;
            }
            return this.elements[index];
        }

        @Override
        public Node set(int index, Node node) {
            if (index < 0 || index >= this.objectIds.length) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            Node retValue = this.elements[index];
            if (retValue == null) {
                retValue = new Node(this.objectIds[index], null, null);
            }
            this.elements[index] = node;
            this.objectIds[index] = node.objectId;
            return retValue;
        }

        @Override
        public void add(int index, Node element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Node o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Node> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Node> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.objectIds.length == 0;
        }

        @Override
        public Iterator<Node> iterator() {
            return new Iterator<Node>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < objectIds.length;
                }

                @Override
                public Node next() {
                    if (this.index >= objectIds.length) {
                        throw new NoSuchElementException();
                    }
                    return this.get(this.index++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<Node> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<Node> listIterator(int index) {
            return new ListIterator<Node>(index){
                int pos;
                int last;
                {
                    this.pos = n;
                    this.last = -1;
                }

                @Override
                public void add(Node o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return this.pos < elements.length;
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                @Override
                public Node next() {
                    if (this.pos >= elements.length) {
                        throw new NoSuchElementException();
                    }
                    Node n = this.get(this.pos);
                    this.last = this.pos++;
                    return n;
                }

                @Override
                public int nextIndex() {
                    return this.pos + 1;
                }

                @Override
                public Node previous() {
                    Node n = this.get(this.pos);
                    this.last = this.pos--;
                    return n;
                }

                @Override
                public int previousIndex() {
                    return this.pos - 1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(Node o) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.set(this.last, o);
                }
            };
        }

        @Override
        public Node remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.objectIds.length;
        }

        @Override
        public List<Node> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            this.createNodesIfNecessary();
            Object[] copy = new Object[this.elements.length];
            System.arraycopy(this.elements, 0, copy, 0, this.elements.length);
            return copy;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            this.createNodesIfNecessary();
            if (a.length < this.elements.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.elements.length);
            }
            System.arraycopy(this.elements, 0, a, 0, this.elements.length);
            if (a.length > this.elements.length) {
                a[this.elements.length] = null;
            }
            return a;
        }

        private void createNodesIfNecessary() {
            if (this.created != this.objectIds.length) {
                int ii = 0;
                while (ii < this.elements.length) {
                    if (this.elements[ii] == null) {
                        this.get(ii);
                    }
                    ++ii;
                }
            }
        }
    }

    private static class LinkedNode
    extends Node {
        Node parent;
        String attribute;

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.parent);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LinkedNode other = (LinkedNode)obj;
            return Objects.equals(this.parent, other.parent);
        }

        private LinkedNode(Node parent, int objectId) {
            super(objectId);
            this.parent = parent;
        }
    }

    private static class Node {
        public static final String NOT_A_GC_ROOT = new String("$ not a gc root $");
        private static final Bytes UNSET = new Bytes(-1L);
        int objectId;
        String label;
        String gcRoots;
        Bytes shallowHeap;
        Bytes retainedHeap;

        public int hashCode() {
            return Objects.hash(this.objectId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.objectId == other.objectId;
        }

        private Node(int objectId) {
            this.objectId = objectId;
            this.shallowHeap = UNSET;
            this.retainedHeap = UNSET;
        }

        /* synthetic */ Node(int n, Node node, Node node2) {
            this(n);
        }
    }

    public static class Outbound
    extends Tree {
        public Outbound(ISnapshot snapshot, int[] objectIds) {
            super(snapshot, objectIds);
        }

        @Override
        protected int[] children(Node node) throws SnapshotException {
            return this.snapshot.getOutboundReferentIds(node.objectId);
        }

        @Override
        protected void fillInAttribute(LinkedNode node) throws SnapshotException {
            IObject heapObject = this.snapshot.getObject(node.parent.objectId);
            long parentAddress = this.snapshot.mapIdToAddress(node.objectId);
            node.attribute = this.extractAttribute(heapObject, parentAddress);
        }

        public URL getIcon(Object row) {
            return Icons.outbound(this.snapshot, ((Node)row).objectId);
        }
    }

    private static abstract class Tree
    implements IResultTree,
    IIconProvider,
    IDecorator {
        protected ISnapshot snapshot;
        private List<?> objects;

        public Tree(ISnapshot snapshot, int[] objectIds) {
            this.snapshot = snapshot;
            this.objects = new LazyList(objectIds);
        }

        public final ResultMetaData getResultMetaData() {
            return null;
        }

        public final Column[] getColumns() {
            return new Column[]{new Column(Messages.Column_ClassName).decorator((IDecorator)this), new Column(Messages.Column_ShallowHeap, Bytes.class).noTotals(), new Column(Messages.Column_RetainedHeap, Bytes.class).noTotals()};
        }

        public final List<?> getElements() {
            return this.objects;
        }

        private final List<?> asList(Node parent, int[] ids) {
            ArrayList<LinkedNode> objects = new ArrayList<LinkedNode>(ids.length);
            int ii = 0;
            while (ii < ids.length) {
                objects.add(new LinkedNode(parent, ids[ii]));
                ++ii;
            }
            return objects;
        }

        public final List<?> getChildren(Object parent) {
            try {
                Node node = (Node)parent;
                int[] outbounds = this.children(node);
                return this.asList(node, outbounds);
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract int[] children(Node var1) throws SnapshotException;

        public final boolean hasChildren(Object element) {
            return true;
        }

        public final Object getColumnValue(Object row, int columnIndex) {
            try {
                Node node = (Node)row;
                switch (columnIndex) {
                    case 0: {
                        if (node.label == null) {
                            IObject obj = this.snapshot.getObject(node.objectId);
                            node.label = obj.getDisplayName();
                            node.shallowHeap = new Bytes(obj.getUsedHeapSize());
                        }
                        return node.label;
                    }
                    case 1: {
                        if (node.shallowHeap.getValue() == -1L) {
                            node.shallowHeap = new Bytes(this.snapshot.getHeapSize(node.objectId));
                        }
                        return node.shallowHeap;
                    }
                    case 2: {
                        if (node.retainedHeap.getValue() == -1L) {
                            node.retainedHeap = new Bytes(this.snapshot.getRetainedHeapSize(node.objectId));
                        }
                        return node.retainedHeap;
                    }
                }
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        public final IContextObject getContext(final Object row) {
            return new IContextObject(){

                public int getObjectId() {
                    return ((Node)row).objectId;
                }
            };
        }

        public final String prefix(Object row) {
            if (row instanceof LinkedNode) {
                LinkedNode node = (LinkedNode)row;
                if (node.attribute == null) {
                    try {
                        this.fillInAttribute(node);
                    }
                    catch (SnapshotException e) {
                        throw new RuntimeException(e);
                    }
                }
                return node.attribute;
            }
            return null;
        }

        protected abstract void fillInAttribute(LinkedNode var1) throws SnapshotException;

        public final String suffix(Object row) {
            Node node = (Node)row;
            if (node.gcRoots == null) {
                try {
                    GCRootInfo[] gc = this.snapshot.getGCRootInfo(node.objectId);
                    node.gcRoots = gc != null ? GCRootInfo.getTypeSetAsString(gc) : Node.NOT_A_GC_ROOT;
                }
                catch (SnapshotException e) {
                    throw new RuntimeException(e);
                }
            }
            return node.gcRoots == Node.NOT_A_GC_ROOT ? null : node.gcRoots;
        }

        protected String extractAttribute(IObject heapObject, long parentAddress) {
            StringBuilder s;
            block8: {
                block7: {
                    s = new StringBuilder(64);
                    if (!(heapObject instanceof IObjectArray)) break block7;
                    IObjectArray heapArray = (IObjectArray)heapObject;
                    int length = heapArray.getLength();
                    int step = 65536;
                    int maxarray = Integer.MAX_VALUE;
                    int maxattribute = 1024;
                    if (length > maxarray) break block8;
                    int i = 0;
                    while (i < length) {
                        long[] l = heapArray.getReferenceArray(i, Math.min(step, length - i));
                        int j = 0;
                        while (j < l.length) {
                            if (l[j] == parentAddress) {
                                if (s.length() > 0) {
                                    s.append(", ");
                                }
                                s.append('[');
                                s.append(i + j);
                                s.append(']');
                                if (s.length() > maxattribute) {
                                    s.append(",...");
                                    i = length;
                                    break;
                                }
                            }
                            ++j;
                        }
                        i += step;
                    }
                    break block8;
                }
                List<NamedReference> refs = heapObject.getOutboundReferences();
                for (NamedReference reference : refs) {
                    if (reference.getObjectAddress() != parentAddress) continue;
                    if (s.length() > 0) {
                        s.append(", ");
                    }
                    s.append(reference.getName());
                }
            }
            return s.toString();
        }
    }
}

