/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.pr;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.internal.github.core.QueryUtils;
import org.eclipse.mylyn.internal.github.ui.GitHubRepositoryQueryPage;
import org.eclipse.mylyn.internal.github.ui.pr.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class PullRequestRepositoryQueryPage
extends GitHubRepositoryQueryPage {
    private Button openButton;
    private Button closedButton;
    private Text titleText;
    private SelectionListener completeListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PullRequestRepositoryQueryPage.this.setPageComplete(PullRequestRepositoryQueryPage.this.isPageComplete());
        }
    };

    public PullRequestRepositoryQueryPage(String pageName, TaskRepository taskRepository, IRepositoryQuery query) {
        super(pageName, taskRepository, query);
        this.setDescription(Messages.PullRequestRepositoryQueryPage_Description);
        this.setPageComplete(false);
    }

    public PullRequestRepositoryQueryPage(TaskRepository taskRepository, IRepositoryQuery query) {
        this("prQueryPage", taskRepository, query);
    }

    private void createOptionsArea(Composite parent) {
        Composite optionsArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(optionsArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)optionsArea);
        Composite statusArea = new Composite(optionsArea, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).equalWidth(false).applyTo(statusArea);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)statusArea);
        new Label(statusArea, 0).setText(Messages.PullRequestRepositoryQueryPage_LabelStatus);
        this.openButton = new Button(statusArea, 32);
        this.openButton.setSelection(true);
        this.openButton.setText(Messages.PullRequestRepositoryQueryPage_StatusOpen);
        this.openButton.addSelectionListener(this.completeListener);
        this.closedButton = new Button(statusArea, 32);
        this.closedButton.setSelection(true);
        this.closedButton.setText(Messages.PullRequestRepositoryQueryPage_StatusClosed);
        this.closedButton.addSelectionListener(this.completeListener);
    }

    public void createControl(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(displayArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)displayArea);
        if (!this.inSearchContainer()) {
            Composite titleArea = new Composite(displayArea, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(titleArea);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)titleArea);
            new Label(titleArea, 0).setText(Messages.PullRequestRepositoryQueryPage_LabelTitle);
            this.titleText = new Text(titleArea, 2052);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.titleText);
            this.titleText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PullRequestRepositoryQueryPage.this.setPageComplete(PullRequestRepositoryQueryPage.this.isPageComplete());
                }
            });
        }
        this.createOptionsArea(displayArea);
        this.initialize();
        this.setControl((Control)displayArea);
    }

    private void initialize() {
        IRepositoryQuery query = this.getQuery();
        if (query == null) {
            return;
        }
        this.titleText.setText(query.getSummary());
        List status = QueryUtils.getAttributes((String)"state", (IRepositoryQuery)query);
        this.closedButton.setSelection(status.contains("closed"));
        this.openButton.setSelection(status.contains("open"));
    }

    public boolean isPageComplete() {
        boolean complete = super.isPageComplete();
        if (complete) {
            String message = null;
            if (!this.openButton.getSelection() && !this.closedButton.getSelection()) {
                message = Messages.PullRequestRepositoryQueryPage_MessageSelectStatus;
            }
            this.setErrorMessage(message);
            complete = message == null;
        }
        return complete;
    }

    public String getQueryTitle() {
        return this.titleText != null ? this.titleText.getText() : null;
    }

    public void applyTo(IRepositoryQuery query) {
        query.setSummary(this.getQueryTitle());
        LinkedList<String> statuses = new LinkedList<String>();
        if (this.openButton.getSelection()) {
            statuses.add("open");
        }
        if (this.closedButton.getSelection()) {
            statuses.add("closed");
        }
        QueryUtils.setAttribute((String)"state", statuses, (IRepositoryQuery)query);
    }
}

