/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.idioms;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.idioms.Idiom;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsModel;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsPackage;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsProvider;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;

public abstract class AbstractIdiomsProvider
implements IdiomsProvider {
    protected IdiomsModel getIdiomModel(@NonNull Class<?> contextClass, @NonNull ResourceSet resourceSet, String path) {
        URL url = contextClass.getResource(path);
        if (url == null) {
            throw new IllegalStateException("Failed to locate " + path + " wrt " + contextClass.getName());
        }
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            try {
                url = FileLocator.resolve((URL)url);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to resolve " + path + " wrt " + contextClass.getName(), e);
            }
        }
        @NonNull URI uri = URI.createFileURI((String)url.getPath());
        return this.getIdiomModel(resourceSet, uri);
    }

    public @NonNull IdiomsModel getIdiomModel(@NonNull ResourceSet resourceSet, @NonNull URI uri) {
        IdiomsPackage.eINSTANCE.getClass();
        Resource resource = resourceSet.getResource(uri, true);
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        @NonNull IdiomsModel castIdiomModel = (IdiomsModel)resource.getContents().get(0);
        return castIdiomModel;
    }

    protected @NonNull Iterable<@NonNull Idiom> getIdioms(IdiomsModel rootIdiomModel) {
        ArrayList<@NonNull Idiom> allIdioms = new ArrayList<Idiom>();
        if (rootIdiomModel != null) {
            for (IdiomsModel idiomModel : rootIdiomModel.getIdiomsModels()) {
                allIdioms.addAll((Collection<Idiom>)SerializationUtils.nullFree(idiomModel.getOwnedIdioms()));
            }
        }
        return allIdioms;
    }
}

