/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.sync;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.infra.sync.EMFDispatch;
import org.eclipse.papyrus.infra.sync.SyncItem;

public abstract class NodePositionSyncDispatcher<M extends EObject, T extends EditPart>
extends EMFDispatch {
    protected SyncItem<M, T> item;
    protected int currentX;
    protected int currentY;

    public NodePositionSyncDispatcher(SyncItem<M, T> item) {
        this.item = item;
        Location location = (Location)((Node)((EditPart)item.getBackend()).getModel()).getLayoutConstraint();
        this.currentX = location.getX();
        this.currentY = location.getY();
    }

    public SyncItem<M, T> getItem() {
        return this.item;
    }

    public EObject getNotifier() {
        Node node = (Node)((EditPart)this.item.getBackend()).getModel();
        return node.getLayoutConstraint();
    }

    public EStructuralFeature getFeature() {
        return null;
    }

    public void onChange(Notification notification) {
        Object feature = notification.getFeature();
        if (feature == NotationPackage.Literals.LOCATION__X || feature == NotationPackage.Literals.LOCATION__Y) {
            Object lc = notification.getNotifier();
            Location location = (Location)lc;
            int x = location.getX();
            int y = location.getY();
            if (this.currentX != x || this.currentY != y) {
                this.onFilteredChange(notification);
                this.currentX = x;
                this.currentY = y;
            }
        }
    }

    protected abstract void onFilteredChange(Notification var1);
}

