/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class MultiDiagramUtil {
    public static Map getSaveOptions() {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return saveOptions;
    }

    public static boolean isDiagramActive(Diagram diagram) {
        Diagram activeDiagram;
        DiagramEditor diagramEditor;
        Diagram activeDiagram2;
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return activeEditor instanceof DiagramEditor ? diagram.equals(activeDiagram2 = (diagramEditor = (DiagramEditor)activeEditor).getDiagram()) : activeEditor != null && (activeDiagram = (Diagram)activeEditor.getAdapter(Diagram.class)) != null && activeDiagram.equals(diagram);
    }

    public static boolean addDiagramAndSave(Diagram diagram, Resource resource, boolean save) {
        if (diagram == null || resource == null) {
            return false;
        }
        resource.getContents().add((Object)diagram);
        if (save) {
            try {
                resource.save(MultiDiagramUtil.getSaveOptions());
            }
            catch (IOException ex) {
                Status status = new Status(4, "org.eclipse.papyrus.uml.diagram.common", "Error saving resource");
                Activator.getDefault().getLog().log((IStatus)status);
                return false;
            }
        }
        return true;
    }

    public static boolean deleteDiagramFromResource(Diagram diagram, Resource resource) {
        if (diagram == null || resource == null) {
            return false;
        }
        resource.getContents().remove((Object)diagram);
        return !resource.getContents().contains((Object)diagram);
    }

    public static void closeEditorsThatShowDiagram(Diagram diagram) {
        IEditorReference[] editors;
        if (diagram == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            DiagramEditor diagramEditor;
            Diagram editorDiagram;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorReference.getEditor(false);
            if (editorPart instanceof DiagramEditor && diagram.equals(editorDiagram = (diagramEditor = (DiagramEditor)editorPart).getDiagram())) {
                page.closeEditor((IEditorPart)diagramEditor, true);
            }
            ++n2;
        }
    }

    public static boolean deleteAndSaveEObjectInResource(URI uri, String fragment) {
        block5: {
            URI resourceURI = uri;
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            try {
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
                Resource resource = resourceSet.getResource(resourceURI, true);
                EObject toDelete = resource.getEObject(fragment);
                if (toDelete == null || !resource.getContents().contains((Object)toDelete)) break block5;
                resource.getContents().remove((Object)toDelete);
                try {
                    resource.save(MultiDiagramUtil.getSaveOptions());
                }
                catch (IOException e) {
                    Log.error(null, (int)0, (String)("Error saving resource " + resource.toString()), (Throwable)e);
                    EMFHelper.unload((ResourceSet)resourceSet);
                    return false;
                }
            }
            finally {
                EMFHelper.unload((ResourceSet)resourceSet);
            }
        }
        return true;
    }

    public static Diagram getOtherDiagram(Diagram diagram) {
        if (diagram == null) {
            return null;
        }
        EObject domainElement = diagram.getElement();
        Resource gmfResource = diagram.eResource();
        for (EObject eObject : gmfResource.getContents()) {
            Diagram newDiagram;
            if (!(eObject instanceof Diagram) || diagram.equals(newDiagram = (Diagram)eObject) || !domainElement.equals(newDiagram.getElement())) continue;
            return newDiagram;
        }
        domainElement = domainElement.eContainer();
        return null;
    }
}

